/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import java.io.BufferedReader;
import java.net.URI;
import java.nio.file.Path;
import net.minecraft.Util;

public class VSCodeExt {
    private static String path = null;
    private static String version = null;

    public static String getVSCodePath() {
        if (path == null && ((path = System.getProperty("kubejs.vscode.path")) == null || path.isEmpty())) {
            path = switch (Util.getPlatform()) {
                case Util.OS.WINDOWS -> System.getenv("LOCALAPPDATA") + "\\Programs\\Microsoft VS Code\\bin\\code.cmd";
                case Util.OS.OSX -> "/Applications/Visual Studio Code.app/Contents/Resources/app/bin/code";
                default -> "/usr/bin/code";
            };
        }
        return path;
    }

    public static String getVersion() {
        block9: {
            if (version == null) {
                version = "";
                try {
                    Process process = new ProcessBuilder(VSCodeExt.getVSCodePath(), "--version").redirectErrorStream(true).start();
                    int result = process.waitFor();
                    if (result != 0) break block9;
                    try (BufferedReader in = process.inputReader();){
                        version = in.readLine().trim();
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }
        return version;
    }

    public static boolean isInstalled() {
        return !VSCodeExt.getVersion().isEmpty();
    }

    public static void openFile(Path path, int line, int column) {
        Util.getPlatform().openUri(URI.create("vscode://file/" + path.toAbsolutePath().toString().replace('\\', '/') + ":" + line + ":" + column));
    }
}

