/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.component;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugins;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.Lazy;
import dev.latvian.mods.rhino.NativeJavaMap;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.component.CustomData;
import org.jetbrains.annotations.Nullable;

public interface DataComponentWrapper {
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_COMPONENT = new DynamicCommandExceptionType(object -> Component.translatableEscape((String)"arguments.item.component.unknown", (Object[])new Object[]{object}));
    public static final Dynamic2CommandExceptionType ERROR_MALFORMED_COMPONENT = new Dynamic2CommandExceptionType((object, object2) -> Component.translatableEscape((String)"arguments.item.component.malformed", (Object[])new Object[]{object, object2}));
    public static final SimpleCommandExceptionType ERROR_EXPECTED_COMPONENT = new SimpleCommandExceptionType((Message)Component.translatable((String)"arguments.item.component.expected"));
    public static final Lazy<Map<DataComponentType<?>, TypeInfo>> TYPE_INFOS = Lazy.identityMap(map -> {
        try {
            for (Field field : DataComponents.class.getDeclaredFields()) {
                Type patt0$temp;
                if (field.getType() != DataComponentType.class || !Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !((patt0$temp = field.getGenericType()) instanceof ParameterizedType)) continue;
                ParameterizedType t = (ParameterizedType)patt0$temp;
                DataComponentType key = (DataComponentType)field.get(null);
                TypeInfo typeInfo = TypeInfo.of((Type)t.getActualTypeArguments()[0]);
                map.put(key, typeInfo);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        KubeJSPlugins.forEachPlugin(map::put, KubeJSPlugin::registerDataComponentTypeDescriptions);
    });
    public static final Lazy<Set<DataComponentType<?>>> VISUAL_DIFFERENCE = Lazy.of(() -> {
        HashSet<DataComponentType> set = new HashSet<DataComponentType>();
        set.add(DataComponents.DAMAGE);
        set.add(DataComponents.MAX_DAMAGE);
        set.add(DataComponents.ENCHANTMENTS);
        set.add(DataComponents.STORED_ENCHANTMENTS);
        set.add(DataComponents.CUSTOM_MODEL_DATA);
        set.add(DataComponents.ENCHANTMENT_GLINT_OVERRIDE);
        set.add(DataComponents.DYED_COLOR);
        set.add(DataComponents.MAP_COLOR);
        set.add(DataComponents.POTION_CONTENTS);
        set.add(DataComponents.TRIM);
        set.add(DataComponents.ENTITY_DATA);
        set.add(DataComponents.BLOCK_ENTITY_DATA);
        set.add(DataComponents.FIREWORK_EXPLOSION);
        set.add(DataComponents.FIREWORKS);
        set.add(DataComponents.PROFILE);
        set.add(DataComponents.BANNER_PATTERNS);
        set.add(DataComponents.BASE_COLOR);
        set.add(DataComponents.POT_DECORATIONS);
        set.add(DataComponents.BLOCK_STATE);
        return set;
    });

    public static TypeInfo getTypeInfo(DataComponentType<?> type) {
        return TYPE_INFOS.get().getOrDefault(type, TypeInfo.NONE);
    }

    public static DataComponentType<?> wrapType(Object object) {
        if (object instanceof DataComponentType) {
            return (DataComponentType)object;
        }
        return (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(ID.mc(object));
    }

    public static DataComponentMap readMap(@Nullable DynamicOps<Tag> registryOps, StringReader reader) throws CommandSyntaxException {
        reader.skipWhitespace();
        if (!reader.canRead()) {
            return DataComponentMap.EMPTY;
        }
        DataComponentMap.Builder builder = null;
        if (reader.canRead() && reader.peek() == '[') {
            reader.skip();
            while (reader.canRead() && reader.peek() != ']') {
                reader.skipWhitespace();
                DataComponentType<?> dataComponentType = DataComponentWrapper.readComponentType(reader);
                reader.skipWhitespace();
                reader.expect('=');
                reader.skipWhitespace();
                int i = reader.getCursor();
                DataResult dataResult = dataComponentType.codecOrThrow().parse(registryOps == null ? NbtOps.INSTANCE : registryOps, (Object)new TagParser(reader).readValue());
                if (builder == null) {
                    builder = DataComponentMap.builder();
                }
                builder.set(dataComponentType, Cast.to(dataResult.getOrThrow(string -> {
                    reader.setCursor(i);
                    return ERROR_MALFORMED_COMPONENT.createWithContext((ImmutableStringReader)reader, (Object)dataComponentType.toString(), string);
                })));
                reader.skipWhitespace();
                if (!reader.canRead() || reader.peek() != ',') break;
                reader.skip();
                reader.skipWhitespace();
                if (reader.canRead()) continue;
                throw ERROR_EXPECTED_COMPONENT.createWithContext((ImmutableStringReader)reader);
            }
            reader.expect(']');
        }
        if (reader.canRead() && reader.peek() == '{') {
            CompoundTag tag = new TagParser(reader).readStruct();
            if (builder == null) {
                builder = DataComponentMap.builder();
            }
            builder.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
        return builder == null ? DataComponentMap.EMPTY : builder.build();
    }

    public static DataComponentPatch readPatch(@Nullable DynamicOps<Tag> registryOps, StringReader reader) throws CommandSyntaxException {
        reader.skipWhitespace();
        if (!reader.canRead()) {
            return DataComponentPatch.EMPTY;
        }
        DataComponentPatch.Builder builder = null;
        if (reader.canRead() && reader.peek() == '[') {
            reader.skip();
            while (reader.canRead() && reader.peek() != ']') {
                boolean remove;
                reader.skipWhitespace();
                boolean bl = remove = reader.canRead() && reader.peek() == '!';
                if (remove) {
                    reader.skipWhitespace();
                }
                DataComponentType<?> dataComponentType = DataComponentWrapper.readComponentType(reader);
                if (remove) {
                    reader.skipWhitespace();
                    if (reader.canRead() && reader.peek() != ']') {
                        reader.expect(',');
                        reader.skipWhitespace();
                    }
                    if (builder == null) {
                        builder = DataComponentPatch.builder();
                    }
                    builder.remove(dataComponentType);
                    continue;
                }
                reader.skipWhitespace();
                reader.expect('=');
                reader.skipWhitespace();
                int i = reader.getCursor();
                DataResult dataResult = dataComponentType.codecOrThrow().parse(registryOps == null ? NbtOps.INSTANCE : registryOps, (Object)new TagParser(reader).readValue());
                if (builder == null) {
                    builder = DataComponentPatch.builder();
                }
                builder.set(dataComponentType, Cast.to(dataResult.getOrThrow(string -> {
                    reader.setCursor(i);
                    return ERROR_MALFORMED_COMPONENT.createWithContext((ImmutableStringReader)reader, (Object)dataComponentType.toString(), string);
                })));
                reader.skipWhitespace();
                if (!reader.canRead() || reader.peek() != ',') break;
                reader.skip();
                reader.skipWhitespace();
                if (reader.canRead()) continue;
                throw ERROR_EXPECTED_COMPONENT.createWithContext((ImmutableStringReader)reader);
            }
            reader.expect(']');
        }
        if (reader.canRead() && reader.peek() == '{') {
            CompoundTag tag = new TagParser(reader).readStruct();
            if (builder == null) {
                builder = DataComponentPatch.builder();
            }
            builder.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
        return builder == null ? DataComponentPatch.EMPTY : builder.build();
    }

    public static DataComponentType<?> readComponentType(StringReader stringReader) throws CommandSyntaxException {
        if (!stringReader.canRead()) {
            throw ERROR_EXPECTED_COMPONENT.createWithContext((ImmutableStringReader)stringReader);
        }
        int i = stringReader.getCursor();
        ResourceLocation resourceLocation = ResourceLocation.read((StringReader)stringReader);
        DataComponentType dataComponentType = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(resourceLocation);
        if (dataComponentType != null && !dataComponentType.isTransient()) {
            return dataComponentType;
        }
        stringReader.setCursor(i);
        throw ERROR_UNKNOWN_COMPONENT.createWithContext((ImmutableStringReader)stringReader, (Object)resourceLocation);
    }

    public static DataComponentPredicate readPredicate(@Nullable DynamicOps<Tag> registryOps, StringReader reader) throws CommandSyntaxException {
        DataComponentMap map = reader.canRead() ? DataComponentWrapper.readMap(registryOps, reader) : DataComponentMap.EMPTY;
        return map.isEmpty() ? DataComponentPredicate.EMPTY : DataComponentPredicate.allOf((DataComponentMap)map);
    }

    public static boolean filter(Object from, TypeInfo target) {
        String s;
        return from == null || from instanceof DataComponentMap || from instanceof DataComponentPatch || from instanceof Map || from instanceof NativeJavaMap || from instanceof String && ((s = (String)from).isEmpty() || s.charAt(0) == '[');
    }

    public static DataComponentMap mapOf(@Nullable DynamicOps<Tag> ops, Object o) {
        try {
            return DataComponentWrapper.readMap(ops, new StringReader(o.toString()));
        }
        catch (CommandSyntaxException ex) {
            throw new RuntimeException("Error parsing DataComponentMap from " + String.valueOf(o), ex);
        }
    }

    public static DataComponentMap mapOrEmptyOf(@Nullable DynamicOps<Tag> ops, Object o) {
        try {
            return DataComponentWrapper.readMap(ops, new StringReader(o.toString()));
        }
        catch (CommandSyntaxException ex) {
            return DataComponentMap.EMPTY;
        }
    }

    public static DataComponentPatch patchOf(@Nullable DynamicOps<Tag> ops, Object o) {
        try {
            return DataComponentWrapper.readPatch(ops, new StringReader(o.toString()));
        }
        catch (CommandSyntaxException ex) {
            throw new RuntimeException("Error parsing DataComponentPatch from " + String.valueOf(o), ex);
        }
    }

    public static DataComponentPatch patchOrEmptyOf(@Nullable DynamicOps<Tag> ops, Object o) {
        try {
            return DataComponentWrapper.readPatch(ops, new StringReader(o.toString()));
        }
        catch (CommandSyntaxException ex) {
            return DataComponentPatch.EMPTY;
        }
    }

    public static StringBuilder mapToString(StringBuilder builder, @Nullable DynamicOps<Tag> ops, DataComponentMap map) {
        builder.append('[');
        boolean first = true;
        for (TypedDataComponent comp : map) {
            ResourceLocation id = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)comp.type());
            Codec codec = comp.type().codec();
            if (id == null || codec == null) continue;
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(ID.reduce(id)).append('=');
            try {
                Object value = codec == Codec.BOOL ? comp.value() : codec.encodeStart(ops == null ? NbtOps.INSTANCE : ops, Cast.to(comp.value())).getOrThrow();
                builder.append(value);
            }
            catch (Throwable ex) {
                builder.append("ERROR[").append(ex.getMessage()).append("]");
            }
        }
        builder.append(']');
        return builder;
    }

    public static StringBuilder patchToString(StringBuilder builder, @Nullable DynamicOps<Tag> ops, DataComponentPatch patch) {
        builder.append('[');
        boolean first = true;
        for (Map.Entry comp : patch.entrySet()) {
            ResourceLocation id = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)((DataComponentType)comp.getKey()));
            Codec codec = ((DataComponentType)comp.getKey()).codec();
            if (id == null || codec == null) continue;
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            if (((Optional)comp.getValue()).isPresent()) {
                builder.append(ID.reduce(id)).append('=');
                try {
                    Object value = codec == Codec.BOOL ? ((Optional)comp.getValue()).get() : codec.encodeStart(ops == null ? NbtOps.INSTANCE : ops, Cast.to(((Optional)comp.getValue()).get())).getOrThrow();
                    builder.append(value);
                }
                catch (Throwable ex) {
                    builder.append("ERROR[").append(ex.getMessage()).append("]");
                }
                continue;
            }
            builder.append('!').append(ID.reduce(id));
        }
        builder.append(']');
        return builder;
    }

    public static DataComponentPatch visualPatch(DataComponentPatch patch) {
        if (patch.isEmpty()) {
            return DataComponentPatch.EMPTY;
        }
        DataComponentPatch.Builder builder = DataComponentPatch.builder();
        for (Map.Entry entry : patch.entrySet()) {
            if (!VISUAL_DIFFERENCE.get().contains(entry.getKey())) continue;
            if (((Optional)entry.getValue()).isPresent()) {
                builder.set((DataComponentType)entry.getKey(), Cast.to(((Optional)entry.getValue()).get()));
                continue;
            }
            builder.remove((DataComponentType)entry.getKey());
        }
        return builder.build();
    }
}

