/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.event;

import dev.latvian.mods.kubejs.event.EventExceptionHandler;
import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.event.EventHandlerContainer;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.event.EventTargetType;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import dev.latvian.mods.kubejs.script.ScriptTypePredicate;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.HideFromJS;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class TargetedEventHandler<E>
extends EventHandler {
    protected Map<Object, EventHandlerContainer[]> extraEventContainers;

    TargetedEventHandler(EventGroup g, String n, ScriptTypePredicate st, EventTargetType<E> target, Supplier<Class<? extends KubeEvent>> e) {
        super(g, n, st, e);
        this.target = target;
        this.extraEventContainers = null;
    }

    @Override
    @HideFromJS
    public TargetedEventHandler<E> hasResult(TypeInfo result) {
        super.hasResult(result);
        return this;
    }

    @Override
    public TargetedEventHandler<E> hasResult() {
        super.hasResult();
        return this;
    }

    @Override
    @HideFromJS
    public TargetedEventHandler<E> exceptionHandler(EventExceptionHandler handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public boolean hasListeners() {
        return this.eventContainers != null || this.extraEventContainers != null;
    }

    public boolean hasListeners(@Nullable E extraId) {
        return this.eventContainers != null || extraId != null && this.extraEventContainers != null && this.extraEventContainers.containsKey(extraId);
    }

    public EventResult post(KubeEvent event, @Nullable E extraId) {
        ScriptTypePredicate scriptTypePredicate = this.scriptTypePredicate;
        if (scriptTypePredicate instanceof ScriptTypeHolder) {
            ScriptTypeHolder type = (ScriptTypeHolder)((Object)scriptTypePredicate);
            return this.postInternal(type, extraId, event);
        }
        throw new IllegalStateException("You must specify which script type to post event to");
    }

    public EventResult post(ScriptTypeHolder type, @Nullable E extraId, KubeEvent event) {
        return this.postInternal(type, extraId, event);
    }

    @Override
    @HideFromJS
    public void clear(ScriptType type) {
        super.clear(type);
        if (this.extraEventContainers != null) {
            Iterator<Map.Entry<Object, EventHandlerContainer[]>> entries = this.extraEventContainers.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<Object, EventHandlerContainer[]> entry = entries.next();
                entry.getValue()[type.ordinal()] = null;
                if (!EventHandlerContainer.isEmpty(entry.getValue())) continue;
                entries.remove();
            }
            if (this.extraEventContainers.isEmpty()) {
                this.extraEventContainers = null;
            }
        }
    }

    @Override
    protected EventHandlerContainer[] createMap(@Nullable Object extraId) {
        EventHandlerContainer[] map;
        if (extraId == null) {
            return super.createMap(extraId);
        }
        if (this.extraEventContainers == null) {
            Object object = this.extraEventContainers = this.target.identity ? new Reference2ObjectOpenHashMap() : new HashMap();
        }
        if ((map = this.extraEventContainers.get(extraId)) == null) {
            map = new EventHandlerContainer[ScriptType.VALUES.length];
            this.extraEventContainers.put(extraId, map);
        }
        return map;
    }

    @Override
    public void forEachListener(ScriptType type, Consumer<EventHandlerContainer> callback) {
        super.forEachListener(type, callback);
        if (this.extraEventContainers != null) {
            for (Map.Entry<Object, EventHandlerContainer[]> entry : this.extraEventContainers.entrySet()) {
                EventHandlerContainer c = entry.getValue()[type.ordinal()];
                while (c != null) {
                    callback.accept(c);
                    c = c.child;
                }
            }
        }
    }

    public Set<E> findUniqueExtraIds(ScriptType type) {
        if (!this.hasListeners()) {
            return Set.of();
        }
        HashSet set = new HashSet();
        this.forEachListener(type, c -> {
            if (c.target != null) {
                set.add(c.target);
            }
        });
        return set;
    }
}

