/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.kubejs.recipe.filter.RecipeMatchContext;
import dev.latvian.mods.rhino.type.TypeInfo;

public class BooleanComponent
implements RecipeComponent<Boolean> {
    public static final RecipeComponentType<Boolean> BOOLEAN = RecipeComponentType.unit(KubeJS.id("boolean"), new BooleanComponent());

    @Override
    public RecipeComponentType<?> type() {
        return BOOLEAN;
    }

    @Override
    public Codec<Boolean> codec() {
        return Codec.BOOL;
    }

    @Override
    public TypeInfo typeInfo() {
        return TypeInfo.BOOLEAN;
    }

    @Override
    public Boolean wrap(RecipeScriptContext cx, Object from) {
        if (from instanceof Boolean) {
            Boolean n = (Boolean)from;
            return n;
        }
        if (from instanceof JsonPrimitive) {
            JsonPrimitive json = (JsonPrimitive)from;
            return json.getAsBoolean();
        }
        if (from instanceof CharSequence) {
            return Boolean.parseBoolean(from.toString());
        }
        throw new IllegalStateException("Expected a boolean!");
    }

    @Override
    public boolean hasPriority(RecipeMatchContext cx, Object from) {
        JsonPrimitive json;
        return from instanceof Boolean || from instanceof JsonPrimitive && (json = (JsonPrimitive)from).isBoolean();
    }

    public String toString() {
        return "boolean";
    }
}

