/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.codec.KubeJSCodecs;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.kubejs.recipe.filter.RecipeMatchContext;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Function;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public interface NumberComponent<S, T extends Number>
extends RecipeComponent<T> {
    public static final IntRange INT = new IntRange(null, Integer.MIN_VALUE, Integer.MAX_VALUE, (Codec<Integer>)Codec.INT);
    public static final LongRange LONG = new LongRange(null, Long.MIN_VALUE, Long.MAX_VALUE, (Codec<Long>)Codec.LONG);
    public static final FloatRange FLOAT = new FloatRange(null, Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY), (Codec<Float>)Codec.FLOAT);
    public static final DoubleRange DOUBLE = new DoubleRange(null, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, (Codec<Double>)Codec.DOUBLE);
    public static final RecipeComponentType<?> INT_TYPE = RecipeComponentType.dynamic(KubeJS.id("int"), RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("min", (Object)Integer.MIN_VALUE).forGetter(IntRange::min), (App)Codec.INT.optionalFieldOf("max", (Object)Integer.MAX_VALUE).forGetter(IntRange::max)).apply((Applicative)instance, NumberComponent::intRange)));
    public static final RecipeComponentType<?> LONG_TYPE = RecipeComponentType.dynamic(KubeJS.id("long"), RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.LONG.optionalFieldOf("min", (Object)Long.MIN_VALUE).forGetter(LongRange::min), (App)Codec.LONG.optionalFieldOf("max", (Object)Long.MAX_VALUE).forGetter(LongRange::max)).apply((Applicative)instance, NumberComponent::longRange)));
    public static final RecipeComponentType<?> FLOAT_TYPE = RecipeComponentType.dynamic(KubeJS.id("float"), RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("min", (Object)Float.valueOf(Float.NEGATIVE_INFINITY)).forGetter(FloatRange::min), (App)Codec.FLOAT.optionalFieldOf("max", (Object)Float.valueOf(Float.POSITIVE_INFINITY)).forGetter(FloatRange::max)).apply((Applicative)instance, NumberComponent::floatRange)));
    public static final RecipeComponentType<?> DOUBLE_TYPE = RecipeComponentType.dynamic(KubeJS.id("double"), RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.optionalFieldOf("min", (Object)Double.NEGATIVE_INFINITY).forGetter(DoubleRange::min), (App)Codec.DOUBLE.optionalFieldOf("max", (Object)Double.POSITIVE_INFINITY).forGetter(DoubleRange::max)).apply((Applicative)instance, NumberComponent::doubleRange)));
    public static final RecipeComponentType<Integer> NON_NEGATIVE_INT = RecipeComponentType.unit(KubeJS.id("non_negative_int"), type -> new IntRange((RecipeComponentType<?>)type, 0, Integer.MAX_VALUE, KubeJSCodecs.NON_NEGATIVE_INT));
    public static final RecipeComponentType<Integer> POSITIVE_INT = RecipeComponentType.unit(KubeJS.id("positive_int"), type -> new IntRange((RecipeComponentType<?>)type, 1, Integer.MAX_VALUE, KubeJSCodecs.POSITIVE_INT));
    public static final RecipeComponentType<Long> NON_NEGATIVE_LONG = RecipeComponentType.unit(KubeJS.id("non_negative_long"), type -> new LongRange((RecipeComponentType<?>)type, 0L, Long.MAX_VALUE, KubeJSCodecs.NON_NEGATIVE_LONG));
    public static final RecipeComponentType<Long> POSITIVE_LONG = RecipeComponentType.unit(KubeJS.id("positive_long"), type -> new LongRange((RecipeComponentType<?>)type, 1L, Long.MAX_VALUE, KubeJSCodecs.POSITIVE_LONG));
    public static final RecipeComponentType<Float> NON_NEGATIVE_FLOAT = RecipeComponentType.unit(KubeJS.id("non_negative_float"), type -> new FloatRange((RecipeComponentType<?>)type, Float.valueOf(0.0f), Float.valueOf(Float.POSITIVE_INFINITY), KubeJSCodecs.NON_NEGATIVE_FLOAT));
    public static final RecipeComponentType<Float> POSITIVE_FLOAT = RecipeComponentType.unit(KubeJS.id("positive_float"), type -> new FloatRange((RecipeComponentType<?>)type, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.POSITIVE_INFINITY), KubeJSCodecs.POSITIVE_FLOAT));
    public static final RecipeComponentType<Double> NON_NEGATIVE_DOUBLE = RecipeComponentType.unit(KubeJS.id("non_negative_double"), type -> new DoubleRange((RecipeComponentType<?>)type, 0.0, Double.POSITIVE_INFINITY, KubeJSCodecs.NON_NEGATIVE_DOUBLE));
    public static final RecipeComponentType<Double> POSITIVE_DOUBLE = RecipeComponentType.unit(KubeJS.id("positive_double"), type -> new DoubleRange((RecipeComponentType<?>)type, (Double)Double.MIN_VALUE, Double.POSITIVE_INFINITY, KubeJSCodecs.POSITIVE_DOUBLE));

    public static IntRange intRange(int min, int max) {
        return min == Integer.MIN_VALUE && max == Integer.MAX_VALUE ? INT : IntRange.of(null, min, max);
    }

    public static LongRange longRange(long min, long max) {
        return min == Long.MIN_VALUE && max == Long.MAX_VALUE ? LONG : LongRange.of(null, min, max);
    }

    public static FloatRange floatRange(float min, float max) {
        return min == Float.NEGATIVE_INFINITY && max == Float.POSITIVE_INFINITY ? FLOAT : FloatRange.of(null, Float.valueOf(min), Float.valueOf(max));
    }

    public static DoubleRange doubleRange(double min, double max) {
        return min == Double.NEGATIVE_INFINITY && max == Double.POSITIVE_INFINITY ? DOUBLE : DoubleRange.of(null, min, max);
    }

    private static Number numberOf(Object from) {
        if (from instanceof Number) {
            Number n = (Number)from;
            return n;
        }
        if (from instanceof JsonPrimitive) {
            JsonPrimitive json = (JsonPrimitive)from;
            return json.getAsNumber();
        }
        if (from instanceof CharSequence) {
            return Double.parseDouble(from.toString());
        }
        throw new IllegalStateException("Expected a number!");
    }

    @Override
    default public TypeInfo typeInfo() {
        return TypeInfo.NUMBER;
    }

    @Override
    default public boolean hasPriority(RecipeMatchContext cx, Object from) {
        JsonPrimitive json;
        return from instanceof Number || from instanceof JsonPrimitive && (json = (JsonPrimitive)from).isNumber();
    }

    public T min();

    public T max();

    public NumberComponent<S, T> range(T var1, T var2);

    default public NumberComponent<S, T> min(T min) {
        return this.range(min, this.max());
    }

    default public NumberComponent<S, T> max(T max) {
        return this.range(this.min(), max);
    }

    default public String toString(@Nullable RecipeComponentType<?> typeOverride, String name, T min, T max) {
        if (typeOverride != null) {
            return typeOverride.toString();
        }
        T mn = this.min();
        T mx = this.max();
        if (min.equals(mn) && max.equals(mx)) {
            return name;
        }
        if (min.equals(mn)) {
            return name + "<min," + String.valueOf(mx) + ">";
        }
        if (max.equals(mx)) {
            return name + "<" + String.valueOf(mn) + ",max>";
        }
        return name + "<" + String.valueOf(mn) + "," + String.valueOf(mx) + ">";
    }

    public static final class IntRange
    extends Record
    implements NumberComponent<IntRange, Integer> {
        @Nullable
        private final RecipeComponentType<?> typeOverride;
        private final Integer min;
        private final Integer max;
        private final Codec<Integer> codec;

        public IntRange(@Nullable RecipeComponentType<?> typeOverride, Integer min, Integer max, Codec<Integer> codec) {
            this.typeOverride = typeOverride;
            this.min = min;
            this.max = max;
            this.codec = codec;
        }

        public static IntRange of(@Nullable RecipeComponentType<?> typeOverride, Integer min, Integer max) {
            return new IntRange(typeOverride, min, max, (Codec<Integer>)Codec.intRange((int)min, (int)max));
        }

        @Override
        public RecipeComponentType<?> type() {
            return this.typeOverride == null ? INT_TYPE : this.typeOverride;
        }

        @Override
        public Codec<Integer> codec() {
            return this.codec;
        }

        @Override
        public TypeInfo typeInfo() {
            return TypeInfo.INT;
        }

        @Override
        public Integer wrap(RecipeScriptContext cx, Object from) {
            return Mth.clamp((int)NumberComponent.numberOf(from).intValue(), (int)this.min, (int)this.max);
        }

        public IntRange range(Integer min, Integer max) {
            return IntRange.of(null, min, max);
        }

        @Override
        public String toString() {
            return this.toString(this.typeOverride, "int", Integer.MIN_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IntRange.class, "typeOverride;min;max;codec", "typeOverride", "min", "max", "codec"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IntRange.class, "typeOverride;min;max;codec", "typeOverride", "min", "max", "codec"}, this, o);
        }

        @Nullable
        public RecipeComponentType<?> typeOverride() {
            return this.typeOverride;
        }

        @Override
        public Integer min() {
            return this.min;
        }

        @Override
        public Integer max() {
            return this.max;
        }
    }

    public static final class LongRange
    extends Record
    implements NumberComponent<LongRange, Long> {
        @Nullable
        private final RecipeComponentType<?> typeOverride;
        private final Long min;
        private final Long max;
        private final Codec<Long> codec;

        public LongRange(@Nullable RecipeComponentType<?> typeOverride, Long min, Long max, Codec<Long> codec) {
            this.typeOverride = typeOverride;
            this.min = min;
            this.max = max;
            this.codec = codec;
        }

        public static LongRange of(@Nullable RecipeComponentType<?> typeOverride, Long min, Long max) {
            Function checker = Codec.checkRange((Number)min, (Number)max);
            return new LongRange(typeOverride, min, max, (Codec<Long>)Codec.LONG.flatXmap(checker, checker));
        }

        @Override
        public RecipeComponentType<?> type() {
            return this.typeOverride == null ? LONG_TYPE : this.typeOverride;
        }

        @Override
        public Codec<Long> codec() {
            return this.codec;
        }

        @Override
        public TypeInfo typeInfo() {
            return TypeInfo.LONG;
        }

        @Override
        public Long wrap(RecipeScriptContext cx, Object from) {
            long val = NumberComponent.numberOf(from).longValue();
            return val < this.min ? this.min : Math.min(val, this.max);
        }

        public LongRange range(Long min, Long max) {
            return LongRange.of(null, min, max);
        }

        @Override
        public String toString() {
            return this.toString(this.typeOverride, "long", Long.MIN_VALUE, Long.MAX_VALUE);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LongRange.class, "typeOverride;min;max;codec", "typeOverride", "min", "max", "codec"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LongRange.class, "typeOverride;min;max;codec", "typeOverride", "min", "max", "codec"}, this, o);
        }

        @Nullable
        public RecipeComponentType<?> typeOverride() {
            return this.typeOverride;
        }

        @Override
        public Long min() {
            return this.min;
        }

        @Override
        public Long max() {
            return this.max;
        }
    }

    public static final class FloatRange
    extends Record
    implements NumberComponent<FloatRange, Float> {
        @Nullable
        private final RecipeComponentType<?> typeOverride;
        private final Float min;
        private final Float max;
        private final Codec<Float> codec;

        public FloatRange(@Nullable RecipeComponentType<?> typeOverride, Float min, Float max, Codec<Float> codec) {
            this.typeOverride = typeOverride;
            this.min = min;
            this.max = max;
            this.codec = codec;
        }

        public static FloatRange of(@Nullable RecipeComponentType<?> typeOverride, Float min, Float max) {
            return new FloatRange(typeOverride, min, max, (Codec<Float>)Codec.floatRange((float)min.floatValue(), (float)max.floatValue()));
        }

        @Override
        public RecipeComponentType<?> type() {
            return this.typeOverride == null ? FLOAT_TYPE : this.typeOverride;
        }

        @Override
        public Codec<Float> codec() {
            return this.codec;
        }

        @Override
        public TypeInfo typeInfo() {
            return TypeInfo.FLOAT;
        }

        @Override
        public Float wrap(RecipeScriptContext cx, Object from) {
            return Float.valueOf(Mth.clamp((float)NumberComponent.numberOf(from).floatValue(), (float)this.min.floatValue(), (float)this.max.floatValue()));
        }

        public FloatRange range(Float min, Float max) {
            return FloatRange.of(null, min, max);
        }

        @Override
        public String toString() {
            return this.toString(this.typeOverride, "float", Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY));
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FloatRange.class, "typeOverride;min;max;codec", "typeOverride", "min", "max", "codec"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FloatRange.class, "typeOverride;min;max;codec", "typeOverride", "min", "max", "codec"}, this, o);
        }

        @Nullable
        public RecipeComponentType<?> typeOverride() {
            return this.typeOverride;
        }

        @Override
        public Float min() {
            return this.min;
        }

        @Override
        public Float max() {
            return this.max;
        }
    }

    public static final class DoubleRange
    extends Record
    implements NumberComponent<DoubleRange, Double> {
        @Nullable
        private final RecipeComponentType<?> typeOverride;
        private final Double min;
        private final Double max;
        private final Codec<Double> codec;

        public DoubleRange(@Nullable RecipeComponentType<?> typeOverride, Double min, Double max, Codec<Double> codec) {
            this.typeOverride = typeOverride;
            this.min = min;
            this.max = max;
            this.codec = codec;
        }

        public static DoubleRange of(@Nullable RecipeComponentType<?> typeOverride, Double min, Double max) {
            return new DoubleRange(typeOverride, min, max, (Codec<Double>)Codec.doubleRange((double)min, (double)max));
        }

        @Override
        public RecipeComponentType<?> type() {
            return this.typeOverride == null ? DOUBLE_TYPE : this.typeOverride;
        }

        @Override
        public Codec<Double> codec() {
            return this.codec;
        }

        @Override
        public TypeInfo typeInfo() {
            return TypeInfo.DOUBLE;
        }

        @Override
        public Double wrap(RecipeScriptContext cx, Object from) {
            return Mth.clamp((double)NumberComponent.numberOf(from).doubleValue(), (double)this.min, (double)this.max);
        }

        public DoubleRange range(Double min, Double max) {
            return DoubleRange.of(null, min, max);
        }

        @Override
        public String toString() {
            return this.toString(this.typeOverride, "double", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DoubleRange.class, "typeOverride;min;max;codec", "typeOverride", "min", "max", "codec"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DoubleRange.class, "typeOverride;min;max;codec", "typeOverride", "min", "max", "codec"}, this, o);
        }

        @Nullable
        public RecipeComponentType<?> typeOverride() {
            return this.typeOverride;
        }

        @Override
        public Double min() {
            return this.min;
        }

        @Override
        public Double max() {
            return this.max;
        }
    }
}

