/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonsizevariation.network;

import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.net.messages.client.pokemon.update.SingleUpdatePacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.UUID;
import kotlin.jvm.functions.Function0;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class SizeChangedPacket
extends SingleUpdatePacket<Double, SizeChangedPacket> {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"cobblemonsizevariation", (String)"pokemon_size_changed");
    private final double newValue;

    public SizeChangedPacket(@NotNull Function0<? extends Pokemon> pokemon, Double value) {
        super(pokemon, (Object)value);
        this.newValue = value;
    }

    public void encodeValue(@NotNull RegistryFriendlyByteBuf buffer) {
        buffer.writeDouble(this.newValue);
    }

    public void set(@NotNull Pokemon pokemon, Double aDouble) {
        pokemon.setScaleModifier(aDouble.floatValue());
    }

    @NotNull
    public ResourceLocation getId() {
        return ID;
    }

    public static SizeChangedPacket decode(RegistryFriendlyByteBuf buffer) {
        Function0<Pokemon> pokemon = SizeChangedPacket.decodePokemon(buffer);
        double newSize = buffer.readDouble();
        return new SizeChangedPacket(pokemon, newSize);
    }

    private static Function0<Pokemon> decodePokemon(RegistryFriendlyByteBuf buffer) {
        UUID store = buffer.readUUID();
        UUID pokemonId = buffer.readUUID();
        return () -> CobblemonClient.INSTANCE.getStorage().locatePokemon(store, pokemonId);
    }
}

