/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.input;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.gui.screens.Screen;
import org.anti_ad.mc.common.IInputHandler;
import org.anti_ad.mc.common.gui.NativeInputContextBase;
import org.anti_ad.mc.common.gui.debug.DebugInfos;
import org.anti_ad.mc.common.gui.screen.ConfigOptionHotkeyDialog;
import org.anti_ad.mc.common.gui.screen.ConfigScreenBase;
import org.anti_ad.mc.common.input.IKeybind;
import org.anti_ad.mc.common.input.KeybindSettings;
import org.anti_ad.mc.common.vanilla.Vanilla;
import org.anti_ad.mc.common.vanilla.VanillaUtil;
import org.anti_ad.mc.libipn.Log;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006J\u001c\u0010\u0014\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u001c\u0010\u0019\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u0010\u0017\u001a\u00020\u0018J$\u0010\u001a\u001a\u00020\u00122\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J\u0014\u0010\u001e\u001a\u00020\u00122\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0002J\b\u0010'\u001a\u00020(H\u0002J\u0016\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020,JB\u0010\u001a\u001a\u00020\u00122\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u00122\u0006\u00100\u001a\u00020,J*\u00101\u001a\u00020\u00122\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u00102\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u0006J\u0012\u00104\u001a\u00020\u00122\n\u0010\u0015\u001a\u000205\"\u00020\u0006J\u0012\u00106\u001a\u00020\u00122\n\u0010\u0015\u001a\u000205\"\u00020\u0006J\u0012\u00107\u001a\u00020\u00122\n\u0010\u0015\u001a\u000205\"\u00020\u0006J\u0012\u00108\u001a\u00020\u00122\n\u0010\u0015\u001a\u000205\"\u00020\u0006J\u0012\u00109\u001a\u00020\u00122\n\u0010\u0015\u001a\u000205\"\u00020\u0006J\u000e\u0010=\u001a\u00020\u00122\u0006\u0010>\u001a\u00020;J\u000e\u0010?\u001a\u00020\u00122\u0006\u0010>\u001a\u00020;J\u000e\u0010@\u001a\u00020\u00122\u0006\u0010>\u001a\u00020;J\u000e\u0010A\u001a\u00020\u00122\u0006\u0010>\u001a\u00020;R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u001e\u0010\f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR(\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\t\u001a\u0004\u0018\u00010\u001f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020;0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/anti_ad/mc/common/input/GlobalInputHandler;", "", "<init>", "()V", "pressedKeys", "", "", "getPressedKeys", "()Ljava/util/Set;", "value", "previousPressedKeys", "getPreviousPressedKeys", "lastKey", "getLastKey", "()I", "lastAction", "getLastAction", "isWaitingForRelease", "", "key", "isActivated", "keyCodes", "", "settings", "Lorg/anti_ad/mc/common/input/KeybindSettings;", "isPressing", "onKey", "context", "Lorg/anti_ad/mc/common/gui/NativeInputContextBase;", "action", "onInput", "Lorg/anti_ad/mc/common/input/IKeybind;", "currentAssigningKeybind", "getCurrentAssigningKeybind", "()Lorg/anti_ad/mc/common/input/IKeybind;", "setCurrentAssigningKeybind", "(Lorg/anti_ad/mc/common/input/IKeybind;)V", "pressedFirstKey", "ignoreLeftClick", "handleAssignKeybind", "", "isKeyDown", "aKeyCode", "window", "", "scanCode", "modifiers", "checkPressing", "handle", "onMouseButton", "button", "mods", "shiftAnd", "", "altAnd", "ctrlAnd", "superAnd", "arePressed", "registered", "Lorg/anti_ad/mc/common/IInputHandler;", "registeredCancellable", "register", "inputHandler", "unregister", "registerCancellable", "unregisterCancellable", "neoforge-1.21"})
@SourceDebugExtension(value={"SMAP\nGlobalInputHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalInputHandler.kt\norg/anti_ad/mc/common/input/GlobalInputHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,286:1\n1761#2,3:287\n1869#2,2:290\n1869#2,2:292\n*S KotlinDebug\n*F\n+ 1 GlobalInputHandler.kt\norg/anti_ad/mc/common/input/GlobalInputHandler\n*L\n108#1:287,3\n113#1:290,2\n188#1:292,2\n*E\n"})
public final class GlobalInputHandler {
    @NotNull
    public static final GlobalInputHandler INSTANCE = new GlobalInputHandler();
    @NotNull
    private static final Set<Integer> pressedKeys = new LinkedHashSet();
    @NotNull
    private static Set<Integer> previousPressedKeys = new LinkedHashSet();
    private static int lastKey = -1;
    private static int lastAction = -1;
    @Nullable
    private static IKeybind currentAssigningKeybind;
    private static boolean pressedFirstKey;
    private static boolean ignoreLeftClick;
    @NotNull
    private static final Set<IInputHandler> registered;
    @NotNull
    private static final Set<IInputHandler> registeredCancellable;

    private GlobalInputHandler() {
    }

    @NotNull
    public final Set<Integer> getPressedKeys() {
        return pressedKeys;
    }

    @NotNull
    public final Set<Integer> getPreviousPressedKeys() {
        return previousPressedKeys;
    }

    public final int getLastKey() {
        return lastKey;
    }

    public final int getLastAction() {
        return lastAction;
    }

    public final boolean isWaitingForRelease(int key) {
        return pressedKeys.contains(key);
    }

    public final boolean isActivated(@NotNull List<Integer> keyCodes, @NotNull KeybindSettings settings) {
        Intrinsics.checkNotNullParameter(keyCodes, (String)"keyCodes");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (keyCodes.isEmpty()) {
            return false;
        }
        if (!settings.getActivateOn().isValid(lastAction)) {
            return false;
        }
        if (!VanillaUtil.INSTANCE.isValidScreen(settings.getContext())) {
            return false;
        }
        Set<Integer> validateKeys = lastAction == 1 ? pressedKeys : previousPressedKeys;
        return KeybindSettings.validates$default(settings, validateKeys, keyCodes, false, 4, null);
    }

    public final boolean isPressing(@NotNull List<Integer> keyCodes, @NotNull KeybindSettings settings) {
        Intrinsics.checkNotNullParameter(keyCodes, (String)"keyCodes");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (keyCodes.isEmpty()) {
            return false;
        }
        if (!VanillaUtil.INSTANCE.isValidScreen(settings.getContext())) {
            return false;
        }
        return settings.validates(pressedKeys, keyCodes, false);
    }

    private final boolean onKey(NativeInputContextBase<?> context, int key, int action) {
        boolean isPress;
        boolean bl = isPress = action == 1;
        if (isPress && pressedKeys.contains(key)) {
            return false;
        }
        boolean bl2 = isPress ? pressedKeys.add(key) : pressedKeys.remove(key);
        lastKey = key;
        lastAction = action;
        return this.onInput(context);
    }

    private final boolean onInput(NativeInputContextBase<?> context) {
        IInputHandler it;
        boolean bl;
        block9: {
            if (currentAssigningKeybind != null) {
                if (lastAction == 1) {
                    this.handleAssignKeybind();
                } else {
                    this.handleAssignKeybind();
                }
                return true;
            }
            Screen screen = Vanilla.INSTANCE.screen();
            if (screen != null && (screen instanceof ConfigScreenBase || screen instanceof ConfigOptionHotkeyDialog)) {
                return false;
            }
            Iterable $this$any$iv = registeredCancellable;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (IInputHandler)element$iv;
                    boolean bl2 = false;
                    if (!it.onInput(context, lastKey, lastAction)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        Iterable $this$forEach$iv = registered;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IInputHandler)element$iv;
            boolean bl3 = false;
            it.onInput(context, lastKey, lastAction);
        }
        return false;
    }

    @Nullable
    public final IKeybind getCurrentAssigningKeybind() {
        return currentAssigningKeybind;
    }

    public final void setCurrentAssigningKeybind(@Nullable IKeybind value) {
        pressedFirstKey = false;
        ignoreLeftClick = true;
        currentAssigningKeybind = value;
    }

    private final void handleAssignKeybind() {
        List<Integer> pressedKeys;
        block14: {
            Object object;
            block13: {
                object = currentAssigningKeybind;
                if (object == null) break block13;
                IKeybind $this$handleAssignKeybind_u24lambda_u242 = object;
                boolean bl = false;
                List<Integer> list = $this$handleAssignKeybind_u24lambda_u242.getSettings().getModifierKey().handleKeys(CollectionsKt.toList((Iterable)GlobalInputHandler.pressedKeys));
                object = list;
                if (list != null) break block14;
            }
            object = pressedKeys = CollectionsKt.toList((Iterable)GlobalInputHandler.pressedKeys);
        }
        if (lastAction == 1) {
            if (lastKey == -100 && ignoreLeftClick) {
                return;
            }
            pressedFirstKey = true;
            if (lastKey == 256) {
                IKeybind iKeybind = currentAssigningKeybind;
                if (iKeybind != null) {
                    iKeybind.setKeyCodes(CollectionsKt.emptyList());
                }
                this.setCurrentAssigningKeybind(null);
            } else {
                IKeybind iKeybind = currentAssigningKeybind;
                if (iKeybind != null) {
                    iKeybind.setKeyCodes(pressedKeys);
                }
            }
        } else {
            if (lastKey == -100) {
                ignoreLeftClick = false;
            }
            if (pressedKeys.isEmpty() && pressedFirstKey) {
                this.setCurrentAssigningKeybind(null);
            }
        }
    }

    public final boolean isKeyDown(int aKeyCode, long window) {
        int keyCode = aKeyCode;
        if (keyCode >= 0) {
            return GLFW.glfwGetKey((long)window, (int)keyCode) == 1;
        }
        return (keyCode += 100) >= 0 && GLFW.glfwGetMouseButton((long)window, (int)keyCode) == 1;
    }

    public final boolean onKey(@NotNull NativeInputContextBase<?> context, int key, int scanCode, int action, int modifiers, boolean checkPressing, long handle) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        DebugInfos.INSTANCE.onKey(context, key, scanCode, action, modifiers);
        previousPressedKeys.clear();
        previousPressedKeys.addAll((Collection<Integer>)pressedKeys);
        if (handle != 0L && checkPressing && !((Collection)pressedKeys).isEmpty()) {
            Set pressed = CollectionsKt.toSet((Iterable)pressedKeys);
            pressedKeys.clear();
            Iterable $this$forEach$iv = pressed;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                if (INSTANCE.isKeyDown(it, handle)) {
                    pressedKeys.add(it);
                    continue;
                }
                if (action != 1) continue;
                INSTANCE.onKey(context, it, 0);
            }
        }
        return switch (action) {
            case 0, 1 -> this.onKey(context, key, action);
            default -> false;
        };
    }

    public final boolean onMouseButton(@NotNull NativeInputContextBase<?> context, int button, int action, int mods) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        DebugInfos.INSTANCE.onMouseButton(context, button, action, mods);
        previousPressedKeys.clear();
        previousPressedKeys.addAll((Collection<Integer>)pressedKeys);
        return switch (action) {
            case 0, 1 -> {
                int normalized;
                int v0 = normalized = button >= 0 ? button - 100 : button;
                if (normalized < 0) {
                    Log.INSTANCE.trace("Mouse button " + normalized + ", " + (action == 1 ? "pressed" : "released"));
                }
                yield this.onKey(context, normalized, action);
            }
            default -> false;
        };
    }

    public final boolean shiftAnd(int ... keyCodes) {
        Intrinsics.checkNotNullParameter((Object)keyCodes, (String)"keyCodes");
        return (pressedKeys.contains(340) || pressedKeys.contains(344)) && pressedKeys.containsAll(ArraysKt.distinct((int[])keyCodes));
    }

    public final boolean altAnd(int ... keyCodes) {
        Intrinsics.checkNotNullParameter((Object)keyCodes, (String)"keyCodes");
        return (pressedKeys.contains(342) || pressedKeys.contains(346)) && pressedKeys.containsAll(ArraysKt.distinct((int[])keyCodes));
    }

    public final boolean ctrlAnd(int ... keyCodes) {
        Intrinsics.checkNotNullParameter((Object)keyCodes, (String)"keyCodes");
        return (pressedKeys.contains(341) || pressedKeys.contains(345)) && pressedKeys.containsAll(ArraysKt.distinct((int[])keyCodes));
    }

    public final boolean superAnd(int ... keyCodes) {
        Intrinsics.checkNotNullParameter((Object)keyCodes, (String)"keyCodes");
        return (pressedKeys.contains(343) || pressedKeys.contains(347)) && pressedKeys.containsAll(ArraysKt.distinct((int[])keyCodes));
    }

    public final boolean arePressed(int ... keyCodes) {
        Intrinsics.checkNotNullParameter((Object)keyCodes, (String)"keyCodes");
        return pressedKeys.containsAll(ArraysKt.distinct((int[])keyCodes));
    }

    public final boolean register(@NotNull IInputHandler inputHandler) {
        Intrinsics.checkNotNullParameter((Object)inputHandler, (String)"inputHandler");
        return registered.add(inputHandler);
    }

    public final boolean unregister(@NotNull IInputHandler inputHandler) {
        Intrinsics.checkNotNullParameter((Object)inputHandler, (String)"inputHandler");
        return registered.remove(inputHandler);
    }

    public final boolean registerCancellable(@NotNull IInputHandler inputHandler) {
        Intrinsics.checkNotNullParameter((Object)inputHandler, (String)"inputHandler");
        return registeredCancellable.add(inputHandler);
    }

    public final boolean unregisterCancellable(@NotNull IInputHandler inputHandler) {
        Intrinsics.checkNotNullParameter((Object)inputHandler, (String)"inputHandler");
        return registeredCancellable.remove(inputHandler);
    }

    static {
        registered = new LinkedHashSet();
        registeredCancellable = new LinkedHashSet();
    }
}

