/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.vanilla;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.anti_ad.mc.alias.text.TextExKt;
import org.anti_ad.mc.common.extensions.Java_ioKt;
import org.anti_ad.mc.common.input.KeybindSettings;
import org.anti_ad.mc.common.vanilla.Vanilla;
import org.anti_ad.mc.common.vanilla.VanillaUtilKt;
import org.anti_ad.mc.common.vanilla.render.ScreenKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\u0005J\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u000b\u001a\u00020\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u0006\u0010\u0012\u001a\u00020\u0010J\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\bJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\bJ\u000e\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0018J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020\u0001\u00a8\u0006*"}, d2={"Lorg/anti_ad/mc/common/vanilla/VanillaUtil;", "", "<init>", "()V", "isOnClientThread", "", "inGame", "languageCode", "", "shiftDown", "ctrlDown", "altDown", "mouseX", "", "mouseY", "mouseXRaw", "", "mouseYRaw", "mouseXDouble", "mouseYDouble", "mouseScaleX", "amount", "mouseScaleY", "runDirectory", "Ljava/nio/file/Path;", "configDirectory", "modName", "getResourceAsString", "identifier", "loggingString", "path", "open", "", "file", "Ljava/io/File;", "url", "Ljava/net/URL;", "isValidScreen", "ctx", "Lorg/anti_ad/mc/common/input/KeybindSettings$Context;", "chat", "message", "neoforge-1.21"})
@SourceDebugExtension(value={"SMAP\nVanillaUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VanillaUtil.kt\norg/anti_ad/mc/common/vanilla/VanillaUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 common.kt\norg/anti_ad/mc/common/extensions/CommonKt\n*L\n1#1,143:1\n1#2:144\n70#3,14:145\n*S KotlinDebug\n*F\n+ 1 VanillaUtil.kt\norg/anti_ad/mc/common/vanilla/VanillaUtil\n*L\n99#1:145,14\n*E\n"})
public final class VanillaUtil {
    @NotNull
    public static final VanillaUtil INSTANCE = new VanillaUtil();

    private VanillaUtil() {
    }

    public final boolean isOnClientThread() {
        return Vanilla.INSTANCE.mc().isSameThread();
    }

    public final boolean inGame() {
        return Vanilla.INSTANCE.worldNullable() != null && Vanilla.INSTANCE.playerNullable() != null;
    }

    @NotNull
    public final String languageCode() {
        String string = Vanilla.INSTANCE.languageManager().getSelected();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSelected(...)");
        return string;
    }

    public final boolean shiftDown() {
        return Screen.hasShiftDown();
    }

    public final boolean ctrlDown() {
        return Screen.hasControlDown();
    }

    public final boolean altDown() {
        return Screen.hasAltDown();
    }

    public final int mouseX() {
        return (int)this.mouseXDouble();
    }

    public final int mouseY() {
        return (int)this.mouseYDouble();
    }

    public final double mouseXRaw() {
        return Vanilla.INSTANCE.mouse().xpos();
    }

    public final double mouseYRaw() {
        return Vanilla.INSTANCE.mouse().ypos();
    }

    public final double mouseXDouble() {
        return this.mouseScaleX(this.mouseXRaw());
    }

    public final double mouseYDouble() {
        return this.mouseScaleY(this.mouseYRaw());
    }

    public final double mouseScaleX(double amount) {
        return amount * (double)ScreenKt.getRScreenWidth() / (double)Vanilla.INSTANCE.window().getScreenWidth();
    }

    public final double mouseScaleY(double amount) {
        return amount * (double)ScreenKt.getRScreenHeight() / (double)Vanilla.INSTANCE.window().getScreenHeight();
    }

    private final Path runDirectory() {
        Path path = Vanilla.INSTANCE.runDirectoryFile().toPath().normalize();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"normalize(...)");
        return path;
    }

    @NotNull
    public final Path configDirectory() {
        return Java_ioKt.div(this.runDirectory(), "config");
    }

    @NotNull
    public final Path configDirectory(@NotNull String modName) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)modName, (String)"modName");
        Path $this$configDirectory_u24lambda_u240 = path = Java_ioKt.div(this.configDirectory(), modName);
        boolean bl = false;
        Java_ioKt.createDirectories($this$configDirectory_u24lambda_u240);
        return path;
    }

    @Nullable
    public final String getResourceAsString(@NotNull String identifier) {
        String string;
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        boolean $i$f$tryCatch = false;
        boolean $i$f$tryCatch2 = false;
        try {
            boolean bl = false;
            InputStream inputStream = ((Resource)Vanilla.INSTANCE.resourceManager().getResource(ResourceLocation.parse((String)identifier)).get()).open();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"open(...)");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            string = TextStreamsKt.readText((Reader)new InputStreamReader(inputStream2, charset));
        }
        catch (Throwable e$iv$iv) {
            e$iv$iv.printStackTrace();
            Throwable it$iv = e$iv$iv;
            boolean bl = false;
            string = null;
        }
        return string;
    }

    @NotNull
    public final String loggingString(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return ((Object)(path.isAbsolute() ? Java_ioKt.pathFrom(path, Java_ioKt.div(this.runDirectory(), "..")) : path)).toString();
    }

    public final void open(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, () -> VanillaUtil.open$lambda$2(file), (int)31, null);
    }

    public final void open(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, () -> VanillaUtil.open$lambda$3(url), (int)31, null);
    }

    public final boolean isValidScreen(@NotNull KeybindSettings.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        return VanillaUtilKt.access$isValid(ctx, Vanilla.INSTANCE.screen());
    }

    public final void chat(@NotNull Object message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Vanilla.INSTANCE.chatHud().addMessage(message instanceof Component ? (Component)message : TextExKt.getLiteral(message.toString()));
    }

    private static final Unit open$lambda$2(File $file) {
        Util.getPlatform().openFile($file);
        return Unit.INSTANCE;
    }

    private static final Unit open$lambda$3(URL $url) {
        Util.getPlatform().openUri($url.toURI());
        return Unit.INSTANCE;
    }
}

