/*
 * Decompiled with CFR 0.152.
 */
package glitchcore.neoforge.network;

import glitchcore.network.CustomPacket;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;

public class GCPayloadFactory<T extends CustomPacket<T>> {
    private final CustomPacketPayload.Type<? extends CustomPacketPayload> type;
    private final CustomPacket<T> packet;
    private final PayloadHandler payloadHandler;

    public GCPayloadFactory(CustomPacketPayload.Type<? extends CustomPacketPayload> type, CustomPacket<T> packet) {
        this.type = type;
        this.packet = packet;
        this.payloadHandler = new PayloadHandler(this);
    }

    public CustomPacketPayload.Type<PacketPayload> type() {
        return this.type;
    }

    public StreamCodec<? super FriendlyByteBuf, PacketPayload> getCodec() {
        return CustomPacketPayload.codec(PacketPayload::write, x$0 -> new PacketPayload(this, (FriendlyByteBuf)x$0));
    }

    public PayloadHandler getPayloadHandler() {
        return this.payloadHandler;
    }

    public PacketPayload createPayload() {
        return new PacketPayload(this, this.packet);
    }

    public class PayloadHandler
    implements IPayloadHandler<PacketPayload> {
        public PayloadHandler(GCPayloadFactory this$0) {
        }

        public void handle(PacketPayload payload, final IPayloadContext context) {
            context.enqueueWork(() -> payload.data.handle(payload.data, new CustomPacket.Context(){

                @Override
                public boolean isClientSide() {
                    return context.flow() == PacketFlow.CLIENTBOUND;
                }

                @Override
                public Optional<Player> getPlayer() {
                    return Optional.ofNullable(context.player()).or(() -> this.isClientSide() ? Optional.ofNullable(Minecraft.getInstance().player) : Optional.empty());
                }
            }));
        }
    }

    public static class PacketPayload
    implements CustomPacketPayload {
        protected final T data;
        final /* synthetic */ GCPayloadFactory this$0;

        private PacketPayload(T data) {
            this.this$0 = this$0;
            this.data = data;
        }

        PacketPayload(GCPayloadFactory this$0, FriendlyByteBuf buf) {
            this.this$0 = this$0;
            this.data = this$0.packet.decode(buf);
        }

        public void write(FriendlyByteBuf buf) {
            this.data.encode(buf);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return this.this$0.type;
        }
    }
}

