/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.scouter.cobblemonoutbreaks.command.OutbreakPortalCommand;
import com.scouter.cobblemonoutbreaks.event.CobblemonOutbreaksEvent;
import com.scouter.cobblemonoutbreaks.manager.OutbreakManager;
import com.scouter.cobblemonoutbreaks.manager.PokemonOutbreakManager;
import com.scouter.cobblemonoutbreaks.portal.entity.OutbreakPortalEntity;
import com.scouter.cobblemonoutbreaks.setup.ModSetup;
import com.scouter.cobblemonoutbreaks.setup.Registration;
import java.util.Locale;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.slf4j.Logger;

@Mod(value="cobblemonoutbreaks")
public class CobblemonOutbreaks {
    public static final String MODID = "cobblemonoutbreaks";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static ServerLevel serverlevel;
    public static boolean serverStarted;

    public CobblemonOutbreaks(IEventBus modEventBus, ModContainer modContainer) {
        Registration.init();
        ModSetup.setup();
        NeoForge.EVENT_BUS.addListener(this::commands);
        modEventBus.addListener(ModSetup::init);
        CobblemonOutbreaks.pokemonCapture();
        CobblemonOutbreaks.pokemonKO();
    }

    public static ResourceLocation prefix(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name.toLowerCase(Locale.ROOT));
    }

    public void commands(RegisterCommandsEvent e) {
        OutbreakPortalCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    public static void pokemonCapture() {
        CobblemonEvents.POKEMON_CAPTURED.subscribe(Priority.HIGH, event -> {
            Level patt0$temp = event.getPlayer().level();
            if (!(patt0$temp instanceof ServerLevel)) {
                return Unit.INSTANCE;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            PokemonOutbreakManager outbreakManager = PokemonOutbreakManager.get((Level)serverLevel);
            Pokemon pokemon = event.getPokemon();
            UUID pokemonUUID = event.getPokemon().getUuid();
            if (!outbreakManager.containsUUID(pokemonUUID)) {
                return Unit.INSTANCE;
            }
            UUID ownerUUID = outbreakManager.getOwnerUUID(pokemonUUID);
            ServerPlayer player = event.getPlayer();
            OutbreakManager outbreakManager1 = OutbreakManager.get((Level)serverLevel);
            OutbreakPortalEntity outbreakPortal = outbreakManager1.getOutbreakEntity(ownerUUID);
            CobblemonOutbreaksEvent.OutbreakPokemonCapture pokemonCapture = new CobblemonOutbreaksEvent.OutbreakPokemonCapture(serverLevel, player, outbreakPortal, pokemon);
            NeoForge.EVENT_BUS.post((Event)pokemonCapture);
            if (outbreakPortal != null) {
                outbreakPortal.removeFromSet(pokemonUUID);
            }
            outbreakManager.removePokemonUUID(pokemonUUID);
            return Unit.INSTANCE;
        });
    }

    public static void pokemonKO() {
        CobblemonEvents.POKEMON_FAINTED.subscribe(Priority.HIGH, event -> {
            UUID pokemonUUID;
            if (event.getPokemon().getOwnerUUID() != null || event.getPokemon() == null || serverlevel == null) {
                return Unit.INSTANCE;
            }
            ServerLevel serverLevel = serverlevel;
            Pokemon pokemon = event.getPokemon();
            PokemonOutbreakManager outbreakManager = PokemonOutbreakManager.get((Level)serverLevel);
            if (!outbreakManager.containsUUID(pokemonUUID = event.getPokemon().getUuid())) {
                return Unit.INSTANCE;
            }
            UUID ownerUUID = outbreakManager.getOwnerUUID(pokemonUUID);
            OutbreakManager outbreakManager1 = OutbreakManager.get((Level)serverLevel);
            OutbreakPortalEntity outbreakPortal = outbreakManager1.getOutbreakEntity(ownerUUID);
            CobblemonOutbreaksEvent.OutbreakPokemonKilled pokemonKO = new CobblemonOutbreaksEvent.OutbreakPokemonKilled(serverLevel, outbreakPortal, pokemon);
            NeoForge.EVENT_BUS.post((Event)pokemonKO);
            if (outbreakPortal != null) {
                outbreakPortal.removeFromSet(pokemonUUID);
            }
            outbreakManager.removePokemonUUID(pokemonUUID);
            return Unit.INSTANCE;
        });
    }

    static {
        serverStarted = false;
    }
}

