/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.algorithms.spawning;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.scouter.cobblemonoutbreaks.data.SpawnAlgorithm;
import com.scouter.cobblemonoutbreaks.data.SpawnAlgorithmType;
import com.scouter.cobblemonoutbreaks.portal.entity.OutbreakPortalEntity;
import com.scouter.cobblemonoutbreaks.registries.SpawnAlgorithmRegistry;
import com.scouter.cobblemonoutbreaks.util.AABBHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;

public class InwardSpiralAlgorithm
implements SpawnAlgorithm {
    public static final MapCodec<InwardSpiralAlgorithm> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.doubleRange((double)5.0, (double)40.0).optionalFieldOf("spawn_range", (Object)15.0).forGetter(InwardSpiralAlgorithm::getSpawnRange), (App)Codec.doubleRange((double)5.0, (double)40.0).optionalFieldOf("leash_range", (Object)32.0).forGetter(InwardSpiralAlgorithm::getLeashRange)).apply((Applicative)instance, InwardSpiralAlgorithm::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, InwardSpiralAlgorithm> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, InwardSpiralAlgorithm::getSpawnRange, (StreamCodec)ByteBufCodecs.DOUBLE, InwardSpiralAlgorithm::getLeashRange, InwardSpiralAlgorithm::new);
    protected double spawnRange;
    protected double leashRange;
    public static final SpawnAlgorithmType<InwardSpiralAlgorithm> TYPE = new SpawnAlgorithmType<InwardSpiralAlgorithm>(){

        @Override
        public MapCodec<InwardSpiralAlgorithm> mapCodec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, InwardSpiralAlgorithm> streamCodec() {
            return STREAM_CODEC;
        }
    };

    public InwardSpiralAlgorithm(double spawnRange, double leashRange) {
        this.spawnRange = spawnRange;
        this.leashRange = leashRange;
    }

    public double getLeashRange() {
        return this.leashRange;
    }

    public double getSpawnRange() {
        return this.spawnRange;
    }

    @Override
    public Vec3 spawnPosition(ServerLevel level, Vec3 pos, OutbreakPortalEntity outbreakPortal, PokemonEntity pokemon) {
        double spawnRange = this.getSpawnRange();
        int tries = 0;
        double x = pos.x() + (-1.0 + 2.0 * level.random.nextDouble()) * spawnRange;
        double y = pos.y() + (double)level.random.nextInt(3) - 1.0;
        double z = pos.z() + (-1.0 + 2.0 * level.random.nextDouble()) * spawnRange;
        while (!level.noCollision(AABBHelper.getAABB(x, y, z, pokemon)) && tries++ < 25) {
            float scaleFactor = (float)(24 - tries) / 25.0f;
            x = pos.x() + (double)scaleFactor * (level.random.nextDouble() - level.random.nextDouble()) * spawnRange + 0.5;
            y = pos.y() + (double)(scaleFactor * (float)level.random.nextInt(3)) + 1.0;
            z = pos.z() + (double)scaleFactor * (level.random.nextDouble() - level.random.nextDouble()) * spawnRange + 0.5;
        }
        while (level.getBlockState(BlockPos.containing((double)x, (double)(y - 1.0), (double)z)).isAir() && y > (double)level.getMinBuildHeight()) {
            y -= 1.0;
        }
        while (!level.noCollision(AABBHelper.getAABB(x, y, z, pokemon))) {
            y += 1.0;
        }
        if (outbreakPortal.distanceToSqr(x, y, z) > this.getLeashRange() * this.getLeashRange()) {
            return null;
        }
        if (level.noCollision(pokemon.getBoundingBox().inflate(x, y, z))) {
            return new Vec3(x, y, z);
        }
        return null;
    }

    @Override
    public SpawnAlgorithmType<? extends SpawnAlgorithm> type() {
        return (SpawnAlgorithmType)SpawnAlgorithmRegistry.INWARD_SPIRAL.get();
    }
}

