/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.codec;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.OptionalFieldCodec;
import java.util.Optional;

public class NullableFieldCodec<VALUE>
extends OptionalFieldCodec<VALUE> {
    private final String name;
    private final Codec<VALUE> elementCodec;

    public static <VALUE> MapCodec<Optional<VALUE>> makeOptionalField(String name, Codec<VALUE> elementCodec) {
        return new NullableFieldCodec<VALUE>(name, elementCodec);
    }

    public static <VALUE> MapCodec<VALUE> makeDefaultableField(String name, Codec<VALUE> elementCodec, VALUE defaultValue) {
        return NullableFieldCodec.makeOptionalField(name, elementCodec).xmap(o -> o.orElse(defaultValue), Optional::ofNullable);
    }

    protected NullableFieldCodec(String name, Codec<VALUE> elementCodec) {
        super(name, elementCodec, false);
        this.name = name;
        this.elementCodec = elementCodec;
    }

    public <T> DataResult<Optional<VALUE>> decode(DynamicOps<T> ops, MapLike<T> input) {
        Object value = input.get(this.name);
        if (value == null) {
            return DataResult.success(Optional.empty());
        }
        return this.elementCodec.parse(ops, value).map(Optional::of);
    }
}

