/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.codec;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.level.ChunkPos;

public class OutbreaksExtraCodec {
    public static final Codec<Boolean> FLEXIBLE_BOOL_CODEC = new Codec<Boolean>(){

        public <T> DataResult<T> encode(Boolean input, DynamicOps<T> ops, T prefix) {
            return Codec.BOOL.encode((Object)input, ops, prefix);
        }

        public <T> DataResult<Pair<Boolean, T>> decode(DynamicOps<T> ops, T input) {
            DataResult boolResult = Codec.BOOL.decode(ops, input);
            if (boolResult.result().isPresent()) {
                return boolResult;
            }
            return Codec.INT.decode(ops, input).map(pair -> Pair.of((Object)((Integer)pair.getFirst() != 0 ? 1 : 0), (Object)pair.getSecond()));
        }

        public String toString() {
            return "FLEXIBLE_BOOL_CODEC";
        }
    };
    public static final Codec<ChunkPos> CHUNK_POS_CODEC = RecordCodecBuilder.create(p_122642_ -> p_122642_.group((App)Codec.LONG.fieldOf("chunk_long").forGetter(ChunkPos::toLong)).apply((Applicative)p_122642_, ChunkPos::new));
    public static final Codec<ChunkPos> CHUNK_POS_CODEC_STRING = Codec.STRING.comapFlatMap(str -> OutbreaksExtraCodec.parseChunkPos(str), intVal -> Long.toString(intVal.toLong()));

    private static final DataResult<ChunkPos> parseChunkPos(String instantString) {
        try {
            return DataResult.success((Object)new ChunkPos(Long.parseLong(instantString)));
        }
        catch (NumberFormatException e) {
            return DataResult.error(() -> e.getMessage());
        }
    }
}

