/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.scouter.cobblemonoutbreaks.data.OutbreaksJsonDataManager;
import com.scouter.cobblemonoutbreaks.manager.OutbreakManager;
import com.scouter.cobblemonoutbreaks.manager.OutbreakPlayerManager;
import com.scouter.cobblemonoutbreaks.manager.OutbreakWorldManager;
import com.scouter.cobblemonoutbreaks.manager.PokemonOutbreakManager;
import com.scouter.cobblemonoutbreaks.portal.OutbreakPortal;
import com.scouter.cobblemonoutbreaks.portal.entity.OutbreakPortalEntity;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.loading.FMLPaths;
import org.slf4j.Logger;

public class OutbreakPortalCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_TYPE = (ctx, builder) -> SharedSuggestionProvider.suggest(OutbreaksJsonDataManager.getData().keySet().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"outbreakportal").requires(s -> s.hasPermission(2));
        builder.then(Commands.literal((String)"flush_pokemon_map").executes(c -> OutbreakPortalCommand.flushPokemonMap((CommandContext<CommandSourceStack>)c)));
        builder.then(Commands.literal((String)"clear_outbreaks").executes(c -> OutbreakPortalCommand.clearOutbreaks((CommandContext<CommandSourceStack>)c)));
        builder.then(Commands.literal((String)"clear_player_timer").executes(c -> OutbreakPortalCommand.clearTimers((CommandContext<CommandSourceStack>)c)));
        builder.then(Commands.literal((String)"set_time_to_config_value").executes(c -> OutbreakPortalCommand.setToConfigValue((CommandContext<CommandSourceStack>)c)));
        builder.then(Commands.literal((String)"update_files").executes(c -> OutbreakPortalCommand.updateFiles((CommandContext<CommandSourceStack>)c)));
        builder.then(Commands.literal((String)"prevent_outbreak_spawns").then(Commands.argument((String)"width", (ArgumentType)IntegerArgumentType.integer((int)1, (int)50)).then(Commands.argument((String)"height", (ArgumentType)IntegerArgumentType.integer((int)1, (int)50)).executes(OutbreakPortalCommand::preventOutbreakSpawns))));
        builder.then(Commands.literal((String)"remove_outbreak_spawns_prevention").then(Commands.argument((String)"width", (ArgumentType)IntegerArgumentType.integer((int)1, (int)50)).then(Commands.argument((String)"height", (ArgumentType)IntegerArgumentType.integer((int)1, (int)50)).executes(OutbreakPortalCommand::removeOutbreakSpawns))));
        builder.then(Commands.argument((String)"pos", (ArgumentType)Vec3Argument.vec3()).then(Commands.argument((String)"type", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_TYPE).executes(c -> OutbreakPortalCommand.openOutBreakPortal((CommandContext<CommandSourceStack>)c, Vec3Argument.getVec3((CommandContext)c, (String)"pos"), ResourceLocationArgument.getId((CommandContext)c, (String)"type")))));
        pDispatcher.register(builder);
    }

    public static int openOutBreakPortal(CommandContext<CommandSourceStack> c, Vec3 pos, ResourceLocation type) {
        try {
            Entity nullableSummoner = ((CommandSourceStack)c.getSource()).getEntity();
            Player summoner = nullableSummoner instanceof Player ? (Player)nullableSummoner : ((CommandSourceStack)c.getSource()).getLevel().getNearestPlayer(pos.x(), pos.y(), pos.z(), 64.0, false);
            BlockPos blockPos = BlockPos.containing((double)pos.x(), (double)pos.y(), (double)pos.z());
            OutbreakPortalEntity outbreakPortalEntity = new OutbreakPortalEntity((Level)((CommandSourceStack)c.getSource()).getLevel(), summoner, type, blockPos);
        }
        catch (Exception ex) {
            ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)"Exception thrown - see log"));
            ex.printStackTrace();
        }
        return 0;
    }

    public static int flushPokemonMap(CommandContext<CommandSourceStack> c) {
        try {
            ServerLevel level = ((CommandSourceStack)c.getSource()).getLevel();
            level.getServer().getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"cobblemonoutbreaks.clearing_pokemon_outbreaks_map").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.ITALIC), true);
            PokemonOutbreakManager pokemonOutbreakManager = PokemonOutbreakManager.get((Level)level);
            pokemonOutbreakManager.clearMap();
            pokemonOutbreakManager.clearTempMap();
        }
        catch (Exception ex) {
            ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)"Exception thrown - see log"));
            ex.printStackTrace();
        }
        return 0;
    }

    public static int clearOutbreaks(CommandContext<CommandSourceStack> c) {
        try {
            ServerLevel level = ((CommandSourceStack)c.getSource()).getLevel();
            level.getServer().getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"cobblemonoutbreaks.clearing_outbreaks_map").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.ITALIC), true);
            OutbreakManager pokemonOutbreakManager = OutbreakManager.get((Level)level);
            pokemonOutbreakManager.clearMap((Level)level);
        }
        catch (Exception ex) {
            ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)"Exception thrown - see log"));
            ex.printStackTrace();
        }
        return 0;
    }

    public static int clearTimers(CommandContext<CommandSourceStack> c) {
        try {
            ServerLevel level = ((CommandSourceStack)c.getSource()).getLevel();
            level.getServer().getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"cobblemonoutbreaks.clear_player_timers").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.ITALIC), true);
            OutbreakPlayerManager outbreakPlayerManager = OutbreakPlayerManager.get((Level)level);
            outbreakPlayerManager.clearTimeLeft();
        }
        catch (Exception ex) {
            ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)"Exception thrown - see log"));
            ex.printStackTrace();
        }
        return 0;
    }

    public static int setToConfigValue(CommandContext<CommandSourceStack> c) {
        try {
            ServerLevel level = ((CommandSourceStack)c.getSource()).getLevel();
            level.getServer().getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"cobblemonoutbreaks.set_to_config_value").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.ITALIC), true);
            OutbreakPlayerManager outbreakPlayerManager = OutbreakPlayerManager.get((Level)level);
            outbreakPlayerManager.setTimeLeftToNewConfig();
            OutbreakWorldManager outbreakWorldManager = OutbreakWorldManager.get((Level)level);
            outbreakWorldManager.setTimeLeftToNewConfig();
        }
        catch (Exception ex) {
            ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)"Exception thrown - see log"));
            ex.printStackTrace();
        }
        return 0;
    }

    public static int updateFiles(CommandContext<CommandSourceStack> c) {
        AtomicInteger updatedFile = new AtomicInteger();
        Entity nullableSummoner = ((CommandSourceStack)c.getSource()).getEntity();
        Path PATH = FMLPaths.GAMEDIR.get().resolve("cobblemon_outbreaks_updated_json_files");
        try {
            Map<ResourceLocation, OutbreakPortal> portals = OutbreaksJsonDataManager.getData();
            try {
                Files.createDirectories(PATH, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Error creating directory: ", (Throwable)e);
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            for (Map.Entry<ResourceLocation, OutbreakPortal> portalEntry : portals.entrySet()) {
                if (!portalEntry.getValue().isOld()) continue;
                OutbreakPortal.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)portalEntry.getValue()).ifSuccess(element -> {
                    try (FileWriter writer = new FileWriter(String.valueOf(PATH) + "/" + ((ResourceLocation)portalEntry.getKey()).getPath() + ".json");){
                        gson.toJson(element, (Appendable)writer);
                        updatedFile.addAndGet(1);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }).ifError(jsonElementError -> LOGGER.error("Failed to update file {} due to {}", portalEntry.getKey(), (Object)jsonElementError.error()));
            }
        }
        catch (Exception ex) {
            ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)"Exception thrown - see log"));
            ex.printStackTrace();
        }
        if (nullableSummoner instanceof Player) {
            Player player = (Player)nullableSummoner;
            player.sendSystemMessage((Component)Component.literal((String)("A new directory has been created at: " + String.valueOf(PATH))).withStyle(ChatFormatting.GREEN));
            player.sendSystemMessage((Component)Component.literal((String)("Updated " + String.valueOf(updatedFile) + " files")).withStyle(ChatFormatting.GREEN));
        }
        return 0;
    }

    public static int preventOutbreakSpawns(CommandContext<CommandSourceStack> c) {
        try {
            ServerLevel level = ((CommandSourceStack)c.getSource()).getLevel();
            Entity entity = ((CommandSourceStack)c.getSource()).getEntity();
            if (!(entity instanceof Player)) {
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)"This command must be run by a player."));
                return 0;
            }
            Player player = (Player)entity;
            BlockPos bottomLeft = player.blockPosition();
            int width = IntegerArgumentType.getInteger(c, (String)"width");
            int height = IntegerArgumentType.getInteger(c, (String)"height");
            OutbreakWorldManager worldManager = OutbreakWorldManager.get((Level)level);
            int addedChunks = OutbreakPortalCommand.addChunksToPreventionList(worldManager, bottomLeft, width, height);
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("Added " + addedChunks + " chunks to the outbreak prevention list.")), true);
        }
        catch (Exception ex) {
            ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)"Exception thrown - see log"));
            ex.printStackTrace();
        }
        return 0;
    }

    public static int removeOutbreakSpawns(CommandContext<CommandSourceStack> c) {
        try {
            ServerLevel level = ((CommandSourceStack)c.getSource()).getLevel();
            Entity entity = ((CommandSourceStack)c.getSource()).getEntity();
            if (!(entity instanceof Player)) {
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)"This command must be run by a player."));
                return 0;
            }
            Player player = (Player)entity;
            BlockPos bottomLeft = player.blockPosition();
            int width = IntegerArgumentType.getInteger(c, (String)"width");
            int height = IntegerArgumentType.getInteger(c, (String)"height");
            OutbreakWorldManager worldManager = OutbreakWorldManager.get((Level)level);
            int removedChunks = OutbreakPortalCommand.removeChunksFromPreventionList(worldManager, bottomLeft, width, height);
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("Removed " + removedChunks + " chunks from the outbreak prevention list.")), true);
        }
        catch (Exception ex) {
            ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)"Exception thrown - see log"));
            ex.printStackTrace();
        }
        return 0;
    }

    private static int addChunksToPreventionList(OutbreakWorldManager worldManager, BlockPos bottomLeft, int width, int height) {
        int addedChunks = 0;
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < height; ++z) {
                ChunkPos chunkPos = new ChunkPos((bottomLeft.getX() >> 4) + x, (bottomLeft.getZ() >> 4) + z);
                if (worldManager.containsChunk(chunkPos)) continue;
                worldManager.addChunkToList(chunkPos);
                ++addedChunks;
            }
        }
        return addedChunks;
    }

    private static int removeChunksFromPreventionList(OutbreakWorldManager worldManager, BlockPos bottomLeft, int width, int height) {
        int removedChunks = 0;
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < height; ++z) {
                ChunkPos chunkPos = new ChunkPos((bottomLeft.getX() >> 4) + x, (bottomLeft.getZ() >> 4) + z);
                if (!worldManager.containsChunk(chunkPos)) continue;
                worldManager.removeChunkFromList(chunkPos);
                ++removedChunks;
            }
        }
        return removedChunks;
    }
}

