/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.scouter.cobblemonoutbreaks.config.GeneralConfig;
import com.scouter.cobblemonoutbreaks.config.MessageConfig;
import com.scouter.cobblemonoutbreaks.config.PortalSpawningConfig;
import com.scouter.cobblemonoutbreaks.config.RarityConfig;
import com.scouter.cobblemonoutbreaks.config.ShinyConfig;
import com.scouter.cobblemonoutbreaks.config.SoundConfig;

public final class OutbreakConfig {
    private final GeneralConfig general;
    private final SoundConfig sound;
    private final MessageConfig messages;
    private final RarityConfig rarities;
    private final PortalSpawningConfig spawningConfig;
    private final ShinyConfig shinyConfig;
    public static final Codec<OutbreakConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GeneralConfig.CODEC.fieldOf("general").orElseGet(GeneralConfig::defaultInstance).forGetter(OutbreakConfig::getGeneral), (App)SoundConfig.CODEC.fieldOf("sound").orElseGet(SoundConfig::defaultInstance).forGetter(OutbreakConfig::getSound), (App)MessageConfig.CODEC.fieldOf("messages").orElseGet(MessageConfig::defaultInstance).forGetter(OutbreakConfig::getMessages), (App)RarityConfig.CODEC.fieldOf("rarities").orElseGet(RarityConfig::defaultInstance).forGetter(OutbreakConfig::getRarities), (App)PortalSpawningConfig.CODEC.fieldOf("portal_spawning_config").orElseGet(() -> PortalSpawningConfig.DEFAULT).forGetter(OutbreakConfig::getSpawningConfig), (App)ShinyConfig.CODEC.fieldOf("shiny_config").orElseGet(ShinyConfig::defaultInstance).forGetter(OutbreakConfig::getShinyConfig)).apply((Applicative)instance, OutbreakConfig::new));
    public static final OutbreakConfig DEFAULT = new OutbreakConfig(GeneralConfig.defaultInstance(), SoundConfig.defaultInstance(), MessageConfig.defaultInstance(), RarityConfig.defaultInstance(), PortalSpawningConfig.DEFAULT, ShinyConfig.defaultInstance());

    public OutbreakConfig(GeneralConfig general, SoundConfig sound, MessageConfig messages, RarityConfig rarities, PortalSpawningConfig spawningConfig, ShinyConfig shinyConfig) {
        this.general = general;
        this.sound = sound;
        this.messages = messages;
        this.rarities = rarities;
        this.spawningConfig = spawningConfig;
        this.shinyConfig = shinyConfig;
    }

    public GeneralConfig getGeneral() {
        return this.general;
    }

    public SoundConfig getSound() {
        return this.sound;
    }

    public MessageConfig getMessages() {
        return this.messages;
    }

    public RarityConfig getRarities() {
        return this.rarities;
    }

    public PortalSpawningConfig getSpawningConfig() {
        return this.spawningConfig;
    }

    public ShinyConfig getShinyConfig() {
        return this.shinyConfig;
    }
}

