/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.config;

import com.mojang.logging.LogUtils;
import com.scouter.cobblemonoutbreaks.config.OutbreakConfig;
import com.scouter.cobblemonoutbreaks.config.helper.fileformats.FileFormat;
import com.scouter.cobblemonoutbreaks.config.helper.fileformats.FileFormats;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import org.slf4j.Logger;

public class OutbreakConfigManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String CONFIG_KEY = "outbreaks_config";
    private static OutbreakConfig config;

    public static OutbreakConfig getConfig() {
        if (config == null) {
            try {
                OutbreakConfigManager.loadOutbreakConfig();
            }
            catch (IOException e) {
                LOGGER.error("Error loading config; falling back to defaults", (Throwable)e);
                config = OutbreakConfig.DEFAULT;
            }
        }
        return config;
    }

    public static void loadOutbreakConfig() throws IOException {
        config = OutbreakConfigManager.loadConfig(FileFormats.OUTBREAK_CONFIG_FILE_FORMAT, FMLPaths.CONFIGDIR.get(), CONFIG_KEY, OutbreakConfig.DEFAULT);
    }

    public static <T> T loadConfig(FileFormat<T> format, Path configDir, String configName, T defaultValue) throws IOException {
        Path configFile = OutbreakConfigManager.getConfigFilePath(configDir, "cobblemonoutbreaks", configName, format);
        if (!Files.exists(configFile = OutbreakConfigManager.ensureFileExtension(configFile, format), new LinkOption[0])) {
            T config = defaultValue;
            Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
            format.getExportStrategy().export(config, configFile);
            LOGGER.info("Default config created at {}", (Object)configFile);
            return defaultValue;
        }
        T loadedConfig = format.getImportStrategy().importData(configFile);
        if (loadedConfig != null) {
            LOGGER.info("Config successfully loaded from {}", (Object)configFile);
            return loadedConfig;
        }
        LOGGER.error("Failed to load config from {}. Falling back to default.", (Object)configFile);
        return defaultValue;
    }

    public static Path getConfigFilePath(Path configDir, String subDir, String fileName, FileFormat<?> format) {
        Path subDirPath = configDir.resolve(subDir);
        String fullName = fileName.endsWith(format.getExtension()) ? fileName : fileName + format.getExtension();
        return subDirPath.resolve(fullName);
    }

    public static <T> Path ensureFileExtension(Path filePath, FileFormat<T> format) {
        String extension = format.getExtension();
        if (!filePath.toString().endsWith(extension)) {
            return Paths.get(filePath.toString() + extension, new String[0]);
        }
        return filePath;
    }

    @EventBusSubscriber(modid="cobblemonoutbreaks", bus=EventBusSubscriber.Bus.GAME)
    public static class onDataPackSynConfigLoad {
        @SubscribeEvent
        public static void onDatapackSync(OnDatapackSyncEvent event) throws IOException {
            if (event.getPlayer() == null) {
                OutbreakConfigManager.loadOutbreakConfig();
            }
        }
    }

    @EventBusSubscriber(modid="cobblemonoutbreaks", bus=EventBusSubscriber.Bus.MOD)
    public static class commonSetupConfigLoad {
        @SubscribeEvent
        public static void onCommonSetup(FMLCommonSetupEvent event) {
            try {
                OutbreakConfigManager.loadOutbreakConfig();
            }
            catch (IOException e) {
                LOGGER.error("Failed to load config during common setup", (Throwable)e);
            }
        }
    }
}

