/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.util.StringRepresentable;

public class PortalSpawningConfig {
    public static final Codec<PortalSpawningConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpawnChoice.CODEC.fieldOf("portal_spawn_choice").forGetter(PortalSpawningConfig::getChoice), (App)Codec.INT.fieldOf("per_player_outbreak_timer").forGetter(PortalSpawningConfig::getPerPlayerOutbreakTimer), (App)Codec.INT.fieldOf("random_outbreak_timer").forGetter(PortalSpawningConfig::getRandomOutbreakTimer), (App)Codec.INT.fieldOf("random_player_count").forGetter(PortalSpawningConfig::getRandomPlayerCount), (App)Codec.INT.fieldOf("outbreak_spawn_count").forGetter(PortalSpawningConfig::getOutbreakSpawnCount), (App)Codec.INT.fieldOf("min_spawn_radius").forGetter(PortalSpawningConfig::getMinSpawnRadius), (App)Codec.INT.fieldOf("max_spawn_radius").forGetter(PortalSpawningConfig::getMaxSpawnRadius)).apply((Applicative)instance, PortalSpawningConfig::new)).validate(e -> e.minSpawnRadius > e.maxSpawnRadius || e.maxSpawnRadius == e.minSpawnRadius || e.minSpawnRadius < 16 || e.maxSpawnRadius > 128 ? DataResult.error(() -> "min_spawn_radius must be smaller than max_spawn_radius and min_spawn_radius cant be smaller than 16 and max_spawn_radius cant be bigger than 128") : DataResult.success((Object)e));
    public static final PortalSpawningConfig DEFAULT = new PortalSpawningConfig(SpawnChoice.PER_PLAYER, 36000, 36000, 2, 3, 32, 64);
    private final SpawnChoice portalSpawnChoice;
    private final int perPlayerOutbreakTimer;
    private final int randomOutbreakTimer;
    private final int randomPlayerCount;
    private final int outbreakSpawnCount;
    private final int minSpawnRadius;
    private final int maxSpawnRadius;

    public PortalSpawningConfig(SpawnChoice choice, int perPlayerTimer, int randomTimer, int randomPlayers, int outbreakCount, int minRadius, int maxRadius) {
        this.portalSpawnChoice = choice;
        this.perPlayerOutbreakTimer = perPlayerTimer;
        this.randomOutbreakTimer = randomTimer;
        this.randomPlayerCount = randomPlayers;
        this.outbreakSpawnCount = outbreakCount;
        this.minSpawnRadius = minRadius;
        this.maxSpawnRadius = maxRadius;
    }

    public int getOutbreakSpawnCount() {
        return this.outbreakSpawnCount;
    }

    public int getPerPlayerOutbreakTimer() {
        return this.perPlayerOutbreakTimer;
    }

    public int getRandomOutbreakTimer() {
        return this.randomOutbreakTimer;
    }

    public int getRandomPlayerCount() {
        return this.randomPlayerCount;
    }

    public SpawnChoice getChoice() {
        return this.portalSpawnChoice;
    }

    public int getMinSpawnRadius() {
        return this.minSpawnRadius;
    }

    public int getMaxSpawnRadius() {
        return this.maxSpawnRadius;
    }

    public boolean isPerPlayer() {
        return this.portalSpawnChoice.equals((Object)SpawnChoice.PER_PLAYER);
    }

    public static enum SpawnChoice implements StringRepresentable
    {
        PER_PLAYER,
        RANDOM_PLAYER;

        public static final Codec<SpawnChoice> CODEC;

        public static SpawnChoice byName(String name) {
            return SpawnChoice.valueOf(name.toUpperCase(Locale.ROOT));
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static SpawnChoice fromId(int id) {
            return SpawnChoice.values()[id];
        }

        static {
            CODEC = StringRepresentable.fromEnum(SpawnChoice::values);
        }
    }
}

