/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.config.helper.fileformats;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.scouter.cobblemonoutbreaks.config.helper.fileformats.ExportFormatStrategy;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;

public class CompoundTagJsonExportStrategy
implements ExportFormatStrategy<CompoundTag> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    @Override
    public void export(CompoundTag data, Path filePath) throws IOException {
        try (FileWriter writer = new FileWriter(filePath.toFile());){
            JsonElement jsonElement = (JsonElement)NbtOps.INSTANCE.convertTo((DynamicOps)JsonOps.INSTANCE, (Tag)data);
            GSON.toJson(jsonElement, (Appendable)writer);
        }
    }

    @Override
    public String getExtension() {
        return ".json";
    }
}

