/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.datagen;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.scouter.cobblemonoutbreaks.CobblemonOutbreaks;
import com.scouter.cobblemonoutbreaks.datagen.OutbreakPortalConsumer;
import com.scouter.cobblemonoutbreaks.portal.OutbreakPortal;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;

public abstract class OutbreakPortalProvider
implements DataProvider {
    protected final PackOutput.PathProvider puppetPathProvider;

    public OutbreakPortalProvider(PackOutput pOutput) {
        this.puppetPathProvider = pOutput.createPathProvider(PackOutput.Target.DATA_PACK, CobblemonOutbreaks.prefix("outbreaks").getPath());
    }

    public CompletableFuture<?> run(CachedOutput pOutput) {
        HashSet set = Sets.newHashSet();
        HashSet taskSet = Sets.newHashSet();
        ArrayList list = new ArrayList();
        this.buildPortal(puppet -> {
            if (!set.add(puppet.getLocation())) {
                throw new IllegalStateException("Duplicate portal " + String.valueOf(puppet.getLocation()));
            }
            OutbreakPortal.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)puppet.getPortal()).ifError(partial -> LOGGER.error("Failed to create outbreak portal {}, due to {}", (Object)puppet.getLocation(), partial)).ifSuccess(e -> list.add(DataProvider.saveStable((CachedOutput)pOutput, (JsonElement)e, (Path)this.puppetPathProvider.json(puppet.getLocation()))));
        });
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    protected abstract void buildPortal(Consumer<OutbreakPortalConsumer> var1);

    public String getName() {
        return "outbreak portal";
    }
}

