/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.datagen;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.scouter.cobblemonoutbreaks.CobblemonOutbreaks;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public abstract class WikiPageBuilderProvider
implements DataProvider {
    protected final PackOutput.PathProvider outputPath;
    private final String modid;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public WikiPageBuilderProvider(PackOutput output, String outputPath, String modid) {
        this.outputPath = output.createPathProvider(PackOutput.Target.DATA_PACK, CobblemonOutbreaks.prefix(outputPath).getPath());
        this.modid = modid;
    }

    protected abstract void generateWikiPages(BiConsumer<String, Supplier<String>> var1);

    public CompletableFuture<?> run(CachedOutput cachedOutput) {
        HashMap entries = new HashMap();
        this.generateWikiPages(entries::put);
        return CompletableFuture.allOf((CompletableFuture[])entries.entrySet().stream().map(entry -> {
            ResourceLocation fileName = CobblemonOutbreaks.prefix((String)entry.getKey());
            Supplier contentSupplier = (Supplier)entry.getValue();
            Path path = this.outputPath.file(fileName, "md");
            return WikiPageBuilderProvider.saveText(contentSupplier, path, cachedOutput);
        }).toArray(CompletableFuture[]::new));
    }

    public static CompletableFuture<?> saveText(Supplier<String> contentSupplier, Path path, CachedOutput cachedOutput) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(contentSupplier).thenApplyAsync(content -> WikiPageBuilderProvider.writeToFile(content, path))).thenAcceptAsync(bytes -> {
            try {
                HashCode hashCode = Hashing.sha256().hashBytes(bytes);
                cachedOutput.writeIfNeeded(path, bytes, hashCode);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to save file to " + String.valueOf(path), e);
            }
        });
    }

    private static byte[] writeToFile(String content, Path path) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                writer.write(content);
            }
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write content to file " + String.valueOf(path), e);
        }
    }

    public static <T> String encodeDataToJsonString(Codec<T> codec, T data) {
        return codec.encodeStart((DynamicOps)JsonOps.INSTANCE, data).map(arg_0 -> ((Gson)GSON).toJson(arg_0)).resultOrPartial(error -> LOGGER.error("Failed to encode Codec to String: {}", error)).orElse("{}");
    }

    public String getName() {
        return "Wiki Page Builder";
    }
}

