/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.lang;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class OutbreakComponentMessages {
    public static Codec<OutbreakComponentMessages> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("translatable").forGetter(OutbreakComponentMessages::getTranslatable), (App)ChatFormatting.CODEC.listOf().fieldOf("message_formatting").forGetter(OutbreakComponentMessages::getMessageFormat), (App)ChatFormatting.CODEC.listOf().fieldOf("args_formatting").forGetter(OutbreakComponentMessages::getArgsFormat)).apply((Applicative)inst, OutbreakComponentMessages::new));
    private final String translatable;
    private final List<ChatFormatting> messageFormat;
    private final List<ChatFormatting> argsFormat;

    public OutbreakComponentMessages(String translatable, List<ChatFormatting> messageFormat, List<ChatFormatting> argsFormat) {
        this.translatable = translatable;
        this.messageFormat = messageFormat;
        this.argsFormat = argsFormat;
    }

    public void sendPlayerMessage(Player player, MutableComponent ... args) {
        if (player == null) {
            return;
        }
        Object[] formattedArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            MutableComponent arg = args[i];
            for (ChatFormatting fmt : this.argsFormat) {
                arg = arg.withStyle(fmt);
            }
            formattedArgs[i] = arg;
        }
        MutableComponent message = Component.translatable((String)this.translatable, (Object[])formattedArgs);
        for (ChatFormatting fmt : this.messageFormat) {
            message = message.withStyle(fmt);
        }
        player.sendSystemMessage((Component)message);
    }

    public void sendPlayerMessage(@Nullable Level level, @Nullable UUID uuid, MutableComponent ... args) {
        if (level == null || uuid == null) {
            return;
        }
        Player player = level.getPlayerByUUID(uuid);
        if (player != null) {
            this.sendPlayerMessage(player, args);
        }
    }

    public void sendPlayerMessage(@Nullable Level level, @Nullable UUID uuid, String arg) {
        this.sendPlayerMessage(level, uuid, Component.literal((String)arg));
    }

    public List<ChatFormatting> getArgsFormat() {
        return this.argsFormat;
    }

    public List<ChatFormatting> getMessageFormat() {
        return this.messageFormat;
    }

    public String getTranslatable() {
        return this.translatable;
    }
}

