/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.manager;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.scouter.cobblemonoutbreaks.portal.entity.OutbreakPortalEntity;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.slf4j.Logger;

public class OutbreakManager
extends SavedData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private Level level = null;
    private Map<UUID, OutbreakPortalEntity> outbreakPortalEntityMap = new ConcurrentHashMap<UUID, OutbreakPortalEntity>();
    private static final Codec<Map<UUID, OutbreakPortalEntity>> MAPPER = Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, OutbreakPortalEntity.CODEC);
    public static final SavedData.Factory<OutbreakManager> OUTBREAK_MANAGER_FACTORY = new SavedData.Factory(OutbreakManager::new, OutbreakManager::new);

    public static OutbreakManager get(Level level) {
        if (level.isClientSide) {
            throw new RuntimeException("Don't access this client-side!");
        }
        ServerLevel serverLevel = level.getServer().overworld();
        DimensionDataStorage storage = serverLevel.getDataStorage();
        return (OutbreakManager)storage.computeIfAbsent(OUTBREAK_MANAGER_FACTORY, "outbreakmanager");
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void clearMap(Level level) {
        for (Map.Entry<UUID, OutbreakPortalEntity> entry : this.outbreakPortalEntityMap.entrySet()) {
            entry.getValue().kill(level);
        }
        this.outbreakPortalEntityMap.clear();
        this.setDirty();
    }

    public Map<UUID, OutbreakPortalEntity> getOutbreakPortalEntityMap() {
        return this.outbreakPortalEntityMap;
    }

    public boolean containsPortal(UUID pos) {
        return this.outbreakPortalEntityMap.containsKey(pos);
    }

    public OutbreakPortalEntity getOutbreakEntity(UUID pos) {
        return this.outbreakPortalEntityMap.get(pos);
    }

    public void addPortal(UUID uuid, OutbreakPortalEntity outbreakPortalEntity) {
        this.outbreakPortalEntityMap.put(uuid, outbreakPortalEntity);
        this.setDirty();
    }

    public void removePortal(UUID pokemonUUID) {
        this.outbreakPortalEntityMap.remove(pokemonUUID);
        this.setDirty();
    }

    public OutbreakManager() {
    }

    public OutbreakManager(CompoundTag compoundTag, HolderLookup.Provider provider) {
        ListTag outbreakList = compoundTag.getList("outbreakList", 10);
        for (int i = 0; i < outbreakList.size(); ++i) {
            CompoundTag outbreakEntry = outbreakList.getCompound(i);
            UUID uuid = outbreakEntry.getUUID("uuid");
            CompoundTag outbreakData = outbreakEntry.getCompound("outbreak");
            DataResult entityResult = OutbreakPortalEntity.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)outbreakData);
            entityResult.ifSuccess(outbreak -> this.outbreakPortalEntityMap.put(uuid, (OutbreakPortalEntity)outbreak)).ifError(error -> LOGGER.error("Failed to load outbreak [{}] due to: {}", (Object)uuid, (Object)error.message()));
        }
        LOGGER.info("Finished loading {} outbreaks", (Object)this.outbreakPortalEntityMap.keySet().size());
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider pRegistries) {
        LOGGER.info("Saving outbreak portal map...");
        ListTag outbreakList = new ListTag();
        for (Map.Entry<UUID, OutbreakPortalEntity> entry : this.outbreakPortalEntityMap.entrySet()) {
            CompoundTag outbreakEntry = new CompoundTag();
            outbreakEntry.putUUID("uuid", entry.getKey());
            DataResult encodedResult = OutbreakPortalEntity.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)entry.getValue());
            encodedResult.ifSuccess(res -> outbreakEntry.put("outbreak", res)).ifError(error -> LOGGER.error("Failed to save outbreak [{}] due to: {}", entry.getKey(), (Object)error.message()));
            outbreakList.add((Object)outbreakEntry);
        }
        compoundTag.put("outbreakList", (Tag)outbreakList);
        return compoundTag;
    }
}

