/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.manager;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.slf4j.Logger;

public class PokemonOutbreakManager
extends SavedData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<UUID, UUID> pokemonOwnershipMap = new ConcurrentHashMap<UUID, UUID>();
    private final Map<UUID, UUID> pokemonOwnerShipMapTemp = new ConcurrentHashMap<UUID, UUID>();
    public static final SavedData.Factory<PokemonOutbreakManager> POKEMON_OUTBREAK_MANAGER_FACTORY = new SavedData.Factory(PokemonOutbreakManager::new, PokemonOutbreakManager::new);
    private static final Codec<Map<UUID, UUID>> MAPPER = Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, (Codec)UUIDUtil.STRING_CODEC);

    public static PokemonOutbreakManager get(Level level) {
        if (level.isClientSide) {
            throw new RuntimeException("Don't access this client-side!");
        }
        ServerLevel serverLevel = level.getServer().overworld();
        DimensionDataStorage storage = serverLevel.getDataStorage();
        return (PokemonOutbreakManager)storage.computeIfAbsent(POKEMON_OUTBREAK_MANAGER_FACTORY, "pokemonoutbreakmanager");
    }

    public void clearMap() {
        this.pokemonOwnershipMap.clear();
        this.setDirty();
    }

    public boolean containsUUID(UUID pokemon) {
        return this.pokemonOwnershipMap.containsKey(pokemon);
    }

    public UUID getOwnerUUID(UUID pokemonUUID) {
        return this.pokemonOwnershipMap.get(pokemonUUID);
    }

    public void addPokemonWOwner(UUID pokemonUUID, UUID ownerUUID) {
        this.pokemonOwnershipMap.put(pokemonUUID, ownerUUID);
        this.setDirty();
    }

    public void removePokemonUUID(UUID pokemonUUID) {
        this.pokemonOwnershipMap.remove(pokemonUUID);
        this.setDirty();
    }

    public void clearTempMap() {
        this.pokemonOwnerShipMapTemp.clear();
        this.setDirty();
    }

    public boolean containsUUIDTemp(UUID pokemon) {
        return this.pokemonOwnerShipMapTemp.containsKey(pokemon);
    }

    public UUID getOwnerUUIDTemp(UUID pokemonUUID) {
        return this.pokemonOwnerShipMapTemp.get(pokemonUUID);
    }

    public void addPokemonWOwnerTemp(UUID pokemonUUID, UUID ownerUUID) {
        this.pokemonOwnerShipMapTemp.put(pokemonUUID, ownerUUID);
        this.setDirty();
    }

    public void removePokemonUUIDTemp(UUID pokemonUUID) {
        this.pokemonOwnerShipMapTemp.remove(pokemonUUID);
        this.setDirty();
    }

    public PokemonOutbreakManager() {
    }

    public PokemonOutbreakManager(CompoundTag compoundTag, HolderLookup.Provider provider) {
        CompoundTag tag = compoundTag.getCompound("pokemon_ownership_map");
        MAPPER.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).ifSuccess(this.pokemonOwnershipMap::putAll).ifError(partial -> LOGGER.error("Failed to load pokemon ownership map due to {}", partial));
        CompoundTag tag1 = compoundTag.getCompound("pokemon_ownership_temp_map");
        MAPPER.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag1).ifSuccess(this.pokemonOwnerShipMapTemp::putAll).ifError(partial -> LOGGER.error("Failed to load pokemon temp ownership map due to {}", partial));
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider pRegistries) {
        MAPPER.encodeStart((DynamicOps)NbtOps.INSTANCE, this.pokemonOwnershipMap).ifSuccess(e -> compoundTag.put("pokemon_ownership_map", e)).ifError(partial -> LOGGER.error("Failed to save pokemon ownership map due to {}", partial));
        MAPPER.encodeStart((DynamicOps)NbtOps.INSTANCE, this.pokemonOwnerShipMapTemp).ifSuccess(e -> compoundTag.put("pokemon_ownership_temp_map", e)).ifError(partial -> LOGGER.error("Failed to save pokemon temp ownership map due to {}", partial)).result().orElse(compoundTag);
        return compoundTag;
    }
}

