/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.portal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.scouter.cobblemonoutbreaks.portal.OutbreakPortalSpawnBiomes;

public class OutbreakPortalSpawnSettings {
    public static final OutbreakPortalSpawnSettings DEFAULT = new OutbreakPortalSpawnSettings(-63, 253, OutbreakPortalSpawnBiomes.DEFAULT);
    public static Codec<OutbreakPortalSpawnSettings> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)-63, (int)255).fieldOf("outbreak_min_y").forGetter(OutbreakPortalSpawnSettings::getMinOutbreakY), (App)Codec.intRange((int)-63, (int)255).fieldOf("outbreak_max_y").forGetter(OutbreakPortalSpawnSettings::getMaxOutbreakY), (App)OutbreakPortalSpawnBiomes.CODEC.fieldOf("biome_settings").forGetter(OutbreakPortalSpawnSettings::getOutbreakPortalSpawnBiomes)).apply((Applicative)inst, OutbreakPortalSpawnSettings::new)).validate(data -> data.minOutbreakY > data.maxOutbreakY ? DataResult.error(() -> "outbreak_min_y needs to be smaller or equal to outbreak_max_y") : DataResult.success((Object)data));
    private final int minOutbreakY;
    private final int maxOutbreakY;
    private final OutbreakPortalSpawnBiomes outbreakPortalSpawnBiomes;

    public OutbreakPortalSpawnSettings(int minOutbreakY, int maxOutbreakY, OutbreakPortalSpawnBiomes outbreakPortalSpawnBiomes) {
        this.minOutbreakY = minOutbreakY;
        this.maxOutbreakY = maxOutbreakY;
        this.outbreakPortalSpawnBiomes = outbreakPortalSpawnBiomes;
    }

    public int getMaxOutbreakY() {
        return this.maxOutbreakY;
    }

    public int getMinOutbreakY() {
        return this.minOutbreakY;
    }

    public OutbreakPortalSpawnBiomes getOutbreakPortalSpawnBiomes() {
        return this.outbreakPortalSpawnBiomes;
    }
}

