/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.portal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.scouter.cobblemonoutbreaks.data.OutbreakWaveData;
import com.scouter.cobblemonoutbreaks.data.SpeciesShinyData;
import com.scouter.cobblemonoutbreaks.portal.PokemonRarity;

public class OutbreakSpecies {
    public static final OutbreakSpecies DEFAULT = new OutbreakSpecies("default", OutbreakWaveData.DEFAULT, SpeciesShinyData.DEFAULT, PokemonRarity.COMMON);
    public static Codec<OutbreakSpecies> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("pokemon").forGetter(OutbreakSpecies::getSpecies), (App)OutbreakWaveData.CODEC.fieldOf("wave_data").forGetter(OutbreakSpecies::getWaveData), (App)SpeciesShinyData.CODEC.fieldOf("species_shiny_data").forGetter(OutbreakSpecies::getSpeciesShinyData), (App)PokemonRarity.CODEC.fieldOf("pokemon_rarity").forGetter(OutbreakSpecies::getPokemonRarity)).apply((Applicative)inst, OutbreakSpecies::new));
    private final String species;
    private final OutbreakWaveData waveData;
    private final SpeciesShinyData speciesShinyData;
    private final PokemonRarity pokemonRarity;

    public OutbreakSpecies(String species, OutbreakWaveData waveData, SpeciesShinyData speciesShinyData, PokemonRarity pokemonRarity) {
        this.species = species;
        this.waveData = waveData;
        this.speciesShinyData = speciesShinyData;
        this.pokemonRarity = pokemonRarity;
    }

    public OutbreakWaveData getWaveData() {
        return this.waveData;
    }

    public PokemonRarity getPokemonRarity() {
        return this.pokemonRarity;
    }

    public SpeciesShinyData getSpeciesShinyData() {
        return this.speciesShinyData;
    }

    public String getSpecies() {
        return this.species;
    }
}

