/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.portal.entity;

import com.cobblemon.mod.common.api.entity.Despawner;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.scouter.cobblemonoutbreaks.CobblemonOutbreaks;
import com.scouter.cobblemonoutbreaks.algorithms.level.RandomAlgorithm;
import com.scouter.cobblemonoutbreaks.codec.NullableFieldCodec;
import com.scouter.cobblemonoutbreaks.config.OutbreakConfigManager;
import com.scouter.cobblemonoutbreaks.data.OutbreaksJsonDataManager;
import com.scouter.cobblemonoutbreaks.event.CobblemonOutbreaksEvent;
import com.scouter.cobblemonoutbreaks.manager.OutbreakManager;
import com.scouter.cobblemonoutbreaks.manager.PokemonOutbreakManager;
import com.scouter.cobblemonoutbreaks.portal.CustomDespawner;
import com.scouter.cobblemonoutbreaks.portal.OutbreakPortal;
import com.scouter.cobblemonoutbreaks.portal.entity.OutbreakPortalEntityIdData;
import com.scouter.cobblemonoutbreaks.portal.entity.OutbreakPortalEntityTickData;
import com.scouter.cobblemonoutbreaks.portal.entity.OutbreakPortalEntityWaveData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;

public class OutbreakPortalEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<OutbreakPortalEntity> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NullableFieldCodec.makeDefaultableField("resource_location", ResourceLocation.CODEC, CobblemonOutbreaks.prefix("default")).forGetter(OutbreakPortalEntity::getResourceLocation), (App)OutbreakPortal.CODEC.fieldOf("portal").forGetter(OutbreakPortalEntity::getPortal), (App)OutbreakPortalEntityIdData.CODEC.fieldOf("id_data").forGetter(OutbreakPortalEntity::getEntityIdData), (App)BlockPos.CODEC.fieldOf("blockpos").forGetter(OutbreakPortalEntity::getBlockPosition), (App)OutbreakPortalEntityTickData.CODEC.fieldOf("tick_data").forGetter(OutbreakPortalEntity::getTickData), (App)OutbreakPortalEntityWaveData.CODEC.fieldOf("wave_data").forGetter(OutbreakPortalEntity::getWaveData), (App)Codec.BOOL.fieldOf("was_cleared").forGetter(OutbreakPortalEntity::isWasCleared)).apply((Applicative)instance, OutbreakPortalEntity::new));
    private final ResourceLocation resourceLocation;
    private final OutbreakPortal portal;
    private final OutbreakPortalEntityIdData entityIdData;
    private BlockPos blockPosition;
    private final OutbreakPortalEntityTickData tickData;
    private final OutbreakPortalEntityWaveData waveData;
    private boolean wasCleared;
    private transient Level level;
    private transient boolean checkLevel = false;
    private PokemonOutbreakManager outbreakManager;
    private final CustomDespawner despawner;

    public OutbreakPortalEntity(Level level, Player player, ResourceLocation resourceLocation, BlockPos pos) {
        OutbreakPortal portal = OutbreaksJsonDataManager.getPortalFromResourceLocation(resourceLocation);
        OutbreakPortalEntityIdData idData = new OutbreakPortalEntityIdData(player.getUUID(), UUID.randomUUID());
        OutbreakPortalEntityTickData tickData = new OutbreakPortalEntityTickData(0, 0);
        OutbreakPortalEntityWaveData waveData = new OutbreakPortalEntityWaveData(0, false);
        this.portal = portal;
        this.entityIdData = idData;
        this.tickData = tickData;
        this.waveData = waveData;
        this.blockPosition = pos;
        this.resourceLocation = resourceLocation;
        this.level = level;
        this.despawner = new CustomDespawner();
        this.addPortalToOutbreakManager(level);
        this.setPokemonOutbreakManager(level);
        this.sendMessageToPlayer(player);
    }

    public OutbreakPortalEntity(Level level, Player player, BlockPos pos) {
        Holder biomeHolder = level.getBiome(pos);
        OutbreakPortal portal = OutbreaksJsonDataManager.getRandomPortalFromBiome((ServerLevel)level, (Holder<Biome>)biomeHolder);
        OutbreakPortalEntityIdData idData = new OutbreakPortalEntityIdData(player.getUUID(), UUID.randomUUID());
        OutbreakPortalEntityTickData tickData = new OutbreakPortalEntityTickData(0, 0);
        OutbreakPortalEntityWaveData waveData = new OutbreakPortalEntityWaveData(0, false);
        this.portal = portal;
        this.entityIdData = idData;
        this.tickData = tickData;
        this.waveData = waveData;
        this.blockPosition = pos;
        this.resourceLocation = portal.getId();
        this.level = level;
        this.despawner = new CustomDespawner();
        this.checkValidY(player);
        this.addPortalToOutbreakManager(level);
        this.setPokemonOutbreakManager(level);
        this.sendMessageToPlayer(player);
        this.outbreakSpawnSound();
    }

    public OutbreakPortalEntity(ResourceLocation resourceLocation, OutbreakPortal portal, OutbreakPortalEntityIdData entityIdData, BlockPos blockPosition, OutbreakPortalEntityTickData tickData, OutbreakPortalEntityWaveData waveData, boolean wasCleared) {
        this.resourceLocation = resourceLocation;
        this.portal = portal;
        this.entityIdData = entityIdData;
        this.blockPosition = blockPosition;
        this.tickData = tickData;
        this.waveData = waveData;
        this.despawner = new CustomDespawner();
        this.wasCleared = wasCleared;
    }

    public void addPortalToOutbreakManager(Level level) {
        OutbreakManager manager = OutbreakManager.get(level);
        manager.addPortal(this.getEntityIdData().getOutbreakUUID(), this);
    }

    public void setPokemonOutbreakManager(Level level) {
        PokemonOutbreakManager outbreakManager;
        this.outbreakManager = outbreakManager = PokemonOutbreakManager.get(level);
    }

    public void checkValidY(Player player) {
        int maxY = this.getPortal().getOutbreakPortalSpawnSettings().getMaxOutbreakY();
        int minY = this.getPortal().getOutbreakPortalSpawnSettings().getMinOutbreakY();
        int y = this.getBlockPosition().getY();
        if (y < minY || y > maxY) {
            this.getPortal().getOutbreakMessageData().getUnluckySpawn().sendPlayerMessage(player, new MutableComponent[0]);
            this.completeOutbreak(false);
        }
    }

    public void sendMessageToPlayer(Player player) {
        if (OutbreakConfigManager.getConfig().getMessages().isSendPortalSpawnMessage()) {
            if (OutbreakConfigManager.getConfig().getMessages().isBiomeSpecificSpawnsDebug()) {
                MutableComponent pokemonMessage = Component.literal((String)this.getPortal().getSpeciesData().getSpecies());
                MutableComponent biomeMessage = Component.literal((String)((ResourceKey)this.level.getBiome(this.blockPosition).unwrapKey().get()).location().toString().split(":")[1]);
                MutableComponent blockPos = Component.literal((String)this.blockPosition.toString());
                this.getPortal().getOutbreakMessageData().getPortalBiomeSpecificSpawnDebug().sendPlayerMessage(player, biomeMessage, blockPos, pokemonMessage);
            } else if (!OutbreakConfigManager.getConfig().getMessages().isBiomeSpecificSpawnsDebug()) {
                MutableComponent pokemonMessage = Component.literal((String)this.getPortal().getSpeciesData().getSpecies());
                MutableComponent blockPos = Component.literal((String)String.valueOf(this.blockPosition));
                this.getPortal().getOutbreakMessageData().getPortalSpawnNearBlockPos().sendPlayerMessage(player, blockPos, pokemonMessage);
            } else {
                MutableComponent pokemonMessage = Component.literal((String)this.getPortal().getSpeciesData().getSpecies());
                this.getPortal().getOutbreakMessageData().getPortalSpawnNear().sendPlayerMessage(player, pokemonMessage);
            }
        }
    }

    public void outbreakSpawnSound() {
        Level level;
        if (OutbreakConfigManager.getConfig().getSound().isOutbreakPortalSpawnSound() && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.getPortal().getOutbreakSounds().getPortalSpawnSound().playSound(serverLevel, this.getBlockPosition());
        }
    }

    public void tick() {
        Level level;
        this.getTickData().increaseTick();
        if (this.isCheckLevel()) {
            this.pokemonStillValidFirstTime();
        }
        if (!this.level.isClientSide) {
            boolean containsPokemon = this.pokemonStillValid();
            if (this.getWaveData().getWave() >= this.getPortal().getSpeciesData().getWaveData().getWaves() && !containsPokemon) {
                if (!this.getWaveData().isHasSpawnedOne()) {
                    if (OutbreakConfigManager.getConfig().getMessages().isSendPortalSpawnMessage()) {
                        this.getPortal().getOutbreakMessageData().getGateFailedSpawning().sendPlayerMessage(this.level, this.getEntityIdData().getOwnerUUID(), this.getPortal().getSpeciesData().getSpecies());
                    }
                } else if (OutbreakConfigManager.getConfig().getMessages().isSendPortalSpawnMessage()) {
                    this.getPortal().getOutbreakMessageData().getGateFinished().sendPlayerMessage(this.level, this.getEntityIdData().getOwnerUUID(), this.getPortal().getSpeciesData().getSpecies());
                }
                this.completeOutbreak(true);
            }
            if (this.getTickData().getTickCount() % 100 == 0 && this.getWaveData().getWave() < this.getPortal().getSpeciesData().getWaveData().getWaves() && !containsPokemon) {
                this.spawnWave();
                if (!this.level.isClientSide) {
                    CobblemonOutbreaksEvent.WaveEnd waveEnd = new CobblemonOutbreaksEvent.WaveEnd((ServerLevel)this.level, this);
                    NeoForge.EVENT_BUS.post((Event)waveEnd);
                }
                OutbreakManager outbreakManager1 = OutbreakManager.get(this.level);
                outbreakManager1.setDirty();
                this.getWaveData().increaseWave();
            }
            if (this.getTickData().getTicksActive() >= this.getPortal().getGateTimer() && this.getWaveData().isHasSpawnedOne()) {
                if (OutbreakConfigManager.getConfig().getMessages().isSendPortalSpawnMessage()) {
                    this.getPortal().getOutbreakMessageData().getGateTimeFinished().sendPlayerMessage(this.level, this.getEntityIdData().getOwnerUUID(), this.getPortal().getSpeciesData().getSpecies());
                }
                this.completeOutbreak(false);
            }
            this.getTickData().increaseTicksActive();
        }
        if ((level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (OutbreakConfigManager.getConfig().getGeneral().isOutbreakParticles()) {
                this.getPortal().getOutbreakAlgorithms().getParticleSpawningAlgorithm().spawnParticle(serverLevel, this.getBlockPosition(), this.getTickData().getTickCount());
            }
        }
    }

    public boolean pokemonStillValid() {
        if (this.level.isClientSide) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)this.level;
        boolean containsPokemon = this.getEntityIdData().getCurrentOutbreakWaveEntities().stream().anyMatch(uuid -> this.getOutbreakManager().containsUUID((UUID)uuid));
        boolean worldHasPokemon = false;
        if (this.getTickData().getTickCount() % 12000 != 0 && containsPokemon) {
            return containsPokemon;
        }
        if (this.getTickData().getTickCount() % 150 == 0) {
            HashSet<UUID> toRemove = new HashSet<UUID>();
            for (UUID uuid1 : this.getEntityIdData().getCurrentOutbreakWaveEntities()) {
                PokemonEntity entity = (PokemonEntity)serverLevel.getEntity(uuid1);
                if (entity == null) {
                    PokemonOutbreakManager pokemonOutbreakManager = PokemonOutbreakManager.get((Level)serverLevel);
                    if (pokemonOutbreakManager.containsUUID(uuid1)) {
                        pokemonOutbreakManager.removePokemonUUID(uuid1);
                    }
                    toRemove.add(uuid1);
                    continue;
                }
                worldHasPokemon = true;
            }
            this.getEntityIdData().getCurrentOutbreakWaveEntities().removeAll(toRemove);
            return containsPokemon && worldHasPokemon;
        }
        return true;
    }

    public void pokemonStillValidFirstTime() {
        if (this.level.isClientSide || this.getTickData().getTickCount() % 150 != 0) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)this.level;
        HashSet<UUID> toRemove = new HashSet<UUID>();
        for (UUID uuid1 : this.getEntityIdData().getCurrentOutbreakWaveEntities()) {
            PokemonEntity entity = (PokemonEntity)serverLevel.getEntity(uuid1);
            PokemonOutbreakManager pokemonOutbreakManager = PokemonOutbreakManager.get((Level)serverLevel);
            if (entity == null) {
                if (pokemonOutbreakManager.containsUUID(uuid1)) {
                    pokemonOutbreakManager.removePokemonUUID(uuid1);
                }
                toRemove.add(uuid1);
                continue;
            }
            pokemonOutbreakManager.removePokemonUUIDTemp(uuid1);
            pokemonOutbreakManager.addPokemonWOwner(uuid1, this.getEntityIdData().getOutbreakUUID());
        }
        this.getEntityIdData().getCurrentOutbreakWaveEntities().removeAll(toRemove);
        this.checkLevel = true;
    }

    public void spawnWave() {
        Vec3 pos = new Vec3(this.getX(), this.getY(), this.getZ());
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List<PokemonEntity> spawned = this.spawnWave(serverLevel, pos, this.getPortal().getSpeciesData().getSpecies());
            for (PokemonEntity e : spawned) {
                if (e.getUUID().equals(null)) continue;
                this.getEntityIdData().getCurrentOutbreakWaveEntities().add((Object)e.getPokemon().getUuid());
                this.getEntityIdData().getTotalOutbreakEntityIds().add((Object)e.getUUID());
                this.getOutbreakManager().addPokemonWOwner(e.getPokemon().getUuid(), this.getEntityIdData().getOutbreakUUID());
            }
            if (!spawned.isEmpty()) {
                this.getWaveData().setHasSpawnedOne(true);
            }
        }
    }

    public List<PokemonEntity> spawnWave(ServerLevel serverLevel, Vec3 pos, String species) {
        ArrayList<PokemonEntity> spawned = new ArrayList<PokemonEntity>();
        int spawnCount = this.getPortal().getSpeciesData().getWaveData().getSpawnsPerWave();
        for (int i = 0; i < spawnCount; ++i) {
            PokemonProperties properties = PokemonProperties.Companion.parse("species=" + species, " ", "=");
            int spawnLevel = 0;
            Player player = this.level.getPlayerByUUID(this.getEntityIdData().getOwnerUUID());
            spawnLevel = player != null ? this.getPortal().getOutbreakAlgorithms().getLevelAlgorithm().getLevel(serverLevel, player) : RandomAlgorithm.ALGO.getLevel(serverLevel, null);
            properties.setLevel(Integer.valueOf(spawnLevel));
            if (properties.getSpecies() == null) {
                if (this.getPortal().getSpeciesData().getSpecies().equals("default")) {
                    for (int j = 0; j < 4; ++j) {
                        LOGGER.error("Species from {} is null, the species: {} is probably spelled incorrectly", (Object)this.getResourceLocation(), (Object)species);
                        LOGGER.error("This is a default setting, it means that you do not have any correct json files in your datapack and no outbreaks can spawn!");
                        LOGGER.error("If you think this is an error please report it to the developer");
                    }
                } else {
                    for (int j = 0; j < 4; ++j) {
                        LOGGER.error("Species from {} is null, the species: {} is probably spelled incorrectly", (Object)this.getResourceLocation(), (Object)species);
                    }
                }
                this.completeOutbreak(false);
                return Collections.emptyList();
            }
            PokemonEntity pokemonEntity = properties.createEntity(this.level);
            pokemonEntity.setDespawner((Despawner)this.getDespawner());
            Vec3 spawnPos = this.getPortal().getOutbreakAlgorithms().getSpawnAlgorithm().spawnPosition(serverLevel, pos, this, pokemonEntity);
            if (spawnPos == null) continue;
            pokemonEntity.setPos(spawnPos);
            Pokemon pokemon1 = pokemonEntity.getPokemon();
            if (pokemon1 == null) continue;
            double shinyChance = 1.0 / this.getPortal().getSpeciesData().getSpeciesShinyData().getShinyChance(pokemon1);
            if (this.level.random.nextDouble() < shinyChance) {
                pokemon1.setShiny(true);
                this.getPortal().getOutbreakSounds().getPokemonShinySound().playSound(serverLevel, this.getBlockPosition());
            }
            this.level.addFreshEntity((Entity)pokemonEntity);
            if (OutbreakConfigManager.getConfig().getSound().isOutbreakPortalSpawnSound()) {
                this.getPortal().getOutbreakSounds().getPortalSpawnSound().playSound(serverLevel, this.getBlockPosition());
            }
            spawned.add(pokemonEntity);
        }
        return spawned;
    }

    public CustomDespawner getDespawner() {
        return this.despawner == null ? new CustomDespawner() : this.despawner;
    }

    public void completeOutbreak(boolean rewards) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (rewards && OutbreakConfigManager.getConfig().getGeneral().isOutbreakSpawnRewards()) {
                this.getPortal().getRewards().spawnExperienceRewards(serverLevel, this.getBlockPosition());
                this.getPortal().getRewards().spawnItemRewards(serverLevel, this.getBlockPosition());
            }
            this.setWasCleared(true);
            this.kill(this.level);
            for (UUID uuid : this.getEntityIdData().getCurrentOutbreakWaveEntities()) {
                this.getOutbreakManager().removePokemonUUID(uuid);
                this.getOutbreakManager().removePokemonUUIDTemp(uuid);
            }
            this.getEntityIdData().getCurrentOutbreakWaveEntities().clear();
            this.getEntityIdData().getTotalOutbreakEntityIds().clear();
            OutbreakManager outbreakManager1 = OutbreakManager.get((Level)serverLevel);
            outbreakManager1.setDirty();
            outbreakManager1.removePortal(this.getEntityIdData().getOutbreakUUID());
            CobblemonOutbreaksEvent.PortalClose portalClose = new CobblemonOutbreaksEvent.PortalClose(serverLevel, this);
            NeoForge.EVENT_BUS.post((Event)portalClose);
        }
    }

    public void kill(Level level) {
        for (UUID e : this.getEntityIdData().getTotalOutbreakEntityIds()) {
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level1 = (ServerLevel)level;
            Entity entity = level1.getEntity(e);
            if (entity != null) {
                entity.kill();
            }
            PokemonOutbreakManager.get(level).removePokemonUUID(e);
            PokemonOutbreakManager.get(level).removePokemonUUIDTemp(e);
        }
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public OutbreakPortal getPortal() {
        return this.portal;
    }

    public OutbreakPortalEntityIdData getEntityIdData() {
        return this.entityIdData;
    }

    public BlockPos getBlockPosition() {
        return this.blockPosition;
    }

    public OutbreakPortalEntityTickData getTickData() {
        return this.tickData;
    }

    public OutbreakPortalEntityWaveData getWaveData() {
        return this.waveData;
    }

    @Nullable
    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public boolean isCheckLevel() {
        return this.checkLevel;
    }

    public void setCheckLevel(boolean checkLevel) {
        this.checkLevel = checkLevel;
    }

    public double getX() {
        return this.blockPosition.getX();
    }

    public double getY() {
        return this.blockPosition.getY();
    }

    public double getZ() {
        return this.blockPosition.getZ();
    }

    public PokemonOutbreakManager getOutbreakManager() {
        if (this.outbreakManager == null) {
            this.setPokemonOutbreakManager(this.level);
        }
        return this.outbreakManager;
    }

    public void setOutbreakManager(PokemonOutbreakManager outbreakManager) {
        this.outbreakManager = outbreakManager;
    }

    public double distanceToSqr(double x, double y, double z) {
        double dx = this.getX() - x;
        double dy = this.getY() - y;
        double dz = this.getZ() - z;
        return dx * dx + dy * dy + dz * dz;
    }

    public void setBlockPosition(Vec3 blockPosition) {
        BlockPos pos;
        this.blockPosition = pos = BlockPos.containing((double)blockPosition.x(), (double)blockPosition.y(), (double)blockPosition.z());
    }

    public void removeFromSet(UUID pokemon) {
        this.getEntityIdData().getCurrentOutbreakWaveEntities().remove((Object)pokemon);
    }

    public boolean isWasCleared() {
        return this.wasCleared;
    }

    public void setWasCleared(boolean wasCleared) {
        this.wasCleared = wasCleared;
    }

    public String toString() {
        return "OutbreakPortalEntity{resourceLocation=" + String.valueOf(this.resourceLocation) + ", portal=" + String.valueOf(this.portal) + ", idData=" + String.valueOf(this.entityIdData) + ", blockPosition=" + String.valueOf(this.blockPosition) + ", tickData=" + String.valueOf(this.tickData) + ", waveData=" + String.valueOf(this.waveData) + ", level=" + String.valueOf(this.level) + ", checkLevel=" + this.checkLevel + "}";
    }
}

