/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.entity.goals;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.List;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HerdMemberFleeGoal
extends Goal {
    private final PokemonEntity herdEntity;
    @Nullable
    private PokemonEntity alphaEntity;
    protected final double speedModifier;
    protected double posX;
    protected double posY;
    protected double posZ;
    protected boolean isRunning;

    public HerdMemberFleeGoal(PokemonEntity herdEntity, double speedModifier) {
        this.herdEntity = herdEntity;
        this.speedModifier = speedModifier;
    }

    public boolean canUse() {
        if (!this.shouldFlee()) {
            return false;
        }
        return this.findRandomPosition();
    }

    private boolean shouldFlee() {
        if (!this.herdEntity.getPokemon().isWild()) {
            return false;
        }
        if (!this.herdEntity.getPokemon().getPersistentData().contains("ALPHA_ID")) {
            return false;
        }
        if (this.herdEntity.getPokemon().getPersistentData().getUUID("ALPHA_ID").toString().isEmpty()) {
            return false;
        }
        this.alphaEntity = this.findAlphaEntity();
        if (this.alphaEntity == null) {
            return false;
        }
        return this.alphaEntity.isBattling();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void start() {
        this.herdEntity.getNavigation().moveTo(this.posX, this.posY, this.posZ, this.speedModifier);
        this.isRunning = true;
    }

    public void stop() {
        this.isRunning = false;
    }

    public boolean canContinueToUse() {
        return !this.herdEntity.getNavigation().isDone();
    }

    protected boolean findRandomPosition() {
        Vec3 vec3 = DefaultRandomPos.getPos((PathfinderMob)this.herdEntity, (int)10, (int)5);
        if (vec3 == null) {
            return false;
        }
        this.posX = vec3.x;
        this.posY = vec3.y;
        this.posZ = vec3.z;
        return true;
    }

    public void tick() {
    }

    private PokemonEntity findAlphaEntity() {
        List list = this.herdEntity.level().getEntitiesOfClass(this.herdEntity.getClass(), this.herdEntity.getBoundingBox().inflate(8.0, 4.0, 8.0));
        for (PokemonEntity entityToCheck : list) {
            if (!this.herdEntity.getPokemon().getPersistentData().getUUID("ALPHA_ID").equals(entityToCheck.getUUID())) continue;
            return entityToCheck;
        }
        return null;
    }
}

