/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.entity.goals;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import org.jetbrains.annotations.Nullable;

public class PokemonFollowAlphaGoal
extends Goal {
    private final PokemonEntity herdEntity;
    @Nullable
    private PokemonEntity alphaEntity;
    private int timeToRecalcPath;

    public PokemonFollowAlphaGoal(PokemonEntity herdEntity) {
        this.herdEntity = herdEntity;
    }

    public boolean canUse() {
        if (!this.herdEntity.getPokemon().isWild()) {
            return false;
        }
        if (!this.herdEntity.getPokemon().getPersistentData().contains("ALPHA_ID")) {
            return false;
        }
        if (this.herdEntity.getPokemon().getPersistentData().getUUID("ALPHA_ID").toString().isEmpty()) {
            return false;
        }
        List list = this.herdEntity.level().getEntitiesOfClass(this.herdEntity.getClass(), this.herdEntity.getBoundingBox().inflate(8.0, 4.0, 8.0));
        PokemonEntity alpha = null;
        double currentMinDist = Double.MAX_VALUE;
        for (PokemonEntity entityToCheck : list) {
            double distanceToAlpha;
            if (!this.herdEntity.getPokemon().getPersistentData().getUUID("ALPHA_ID").equals(entityToCheck.getUUID()) || (distanceToAlpha = this.herdEntity.distanceToSqr((Entity)entityToCheck)) > currentMinDist) continue;
            currentMinDist = distanceToAlpha;
            alpha = entityToCheck;
        }
        if (alpha == null) {
            return false;
        }
        if (currentMinDist < 9.0) {
            return false;
        }
        this.alphaEntity = alpha;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.alphaEntity == null) {
            return false;
        }
        if (this.alphaEntity.isBattling()) {
            return false;
        }
        if (!this.alphaEntity.isAlive()) {
            return false;
        }
        double distanceToAlpha = this.herdEntity.distanceToSqr((Entity)this.alphaEntity);
        return !(distanceToAlpha < 9.0) && !(distanceToAlpha > 256.0);
    }

    public void start() {
        this.timeToRecalcPath = 0;
    }

    public void stop() {
        this.alphaEntity = null;
    }

    public void tick() {
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            this.herdEntity.getNavigation().moveTo((Entity)this.alphaEntity, 1.0);
        }
    }
}

