/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.entity.spawner;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.abilities.Ability;
import com.cobblemon.mod.common.api.abilities.AbilityPool;
import com.cobblemon.mod.common.api.abilities.AbilityTemplate;
import com.cobblemon.mod.common.api.abilities.PotentialAbility;
import com.cobblemon.mod.common.api.entity.Despawner;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.IVs;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import dev.cudzer.cobblemonalphas.CobblemonAlphasMod;
import dev.cudzer.cobblemonalphas.config.ModConfig;
import dev.cudzer.cobblemonalphas.data.AlphaJsonDataManager;
import dev.cudzer.cobblemonalphas.entity.Alpha;
import dev.cudzer.cobblemonalphas.entity.HerdMember;
import dev.cudzer.cobblemonalphas.entity.spawner.AlphaDespawner;
import dev.cudzer.cobblemonalphas.entity.spawner.spawnData.location.ISpawnLocation;
import dev.cudzer.cobblemonalphas.entity.spawner.spawnData.location.RandomSpawnAroundPlayer;
import dev.cudzer.cobblemonalphas.entity.spawner.spawnData.safety.BlockBlacklist;
import dev.cudzer.cobblemonalphas.entity.spawner.spawnData.safety.HeightBounds;
import dev.cudzer.cobblemonalphas.entity.spawner.spawnData.safety.ISpawnCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;

public class AlphaSpawner {
    private static final AlphaSpawner instance = new AlphaSpawner();
    private int spawnCountdown;
    private ISpawnLocation spawnLocationSelector;
    private List<ISpawnCondition> spawnConditions;
    private static final int HERD_SIZE = 4;
    private MinecraftServer server;
    private static final String[] statNames = new String[]{"HP", "ATTACK", "DEFENCE", "SPECIAL_ATTACK", "SPECIAL_DEFENCE", "SPEED"};

    public static AlphaSpawner getInstance() {
        return instance;
    }

    public void init() {
        this.spawnCountdown = ModConfig.ticksBetweenSpawns;
        this.spawnLocationSelector = new RandomSpawnAroundPlayer(ModConfig.minimumSpawnDistance, ModConfig.maximumSpawnDistance);
        this.spawnConditions = List.of(new BlockBlacklist(List.of(Blocks.LAVA, Blocks.FIRE, Blocks.CACTUS)), new HeightBounds(-50, 200));
        AlphaDespawner.getInstance().setMinimumDespawnDistance(ModConfig.minimumSpawnDistance);
        AlphaDespawner.getInstance().setSpawnIntervalTicks(ModConfig.ticksBetweenSpawns);
        AlphaJsonDataManager.populateBiomeData(this.server.getLevel(Level.OVERWORLD));
    }

    public void setServer(MinecraftServer server) {
        this.server = server;
    }

    public void tick() {
        if (this.spawnCountdown > 0) {
            --this.spawnCountdown;
        } else {
            this.attemptSpawn();
            this.spawnCountdown = ModConfig.ticksBetweenSpawns;
        }
    }

    private void attemptSpawn() {
        Alpha tempAlpha;
        BlockPos finalSpawnPos;
        Vec3i spawnLocation;
        Level chosenPlayerSpawnLevel;
        ServerPlayer chosenPlayer;
        List players = this.server.getPlayerList().getPlayers();
        if (players.size() < ModConfig.requiredPlayerAmount) {
            return;
        }
        if (Math.random() > (double)(ModConfig.alphaSpawnChance + 0.02f * (float)(this.server.getPlayerCount() - ModConfig.requiredPlayerAmount))) {
            return;
        }
        Alpha chosenAlpha = AlphaJsonDataManager.getRandomAlphaObj((Level)this.server.overworld());
        int attemptedSpawns = 0;
        while (true) {
            if (++attemptedSpawns > ModConfig.spawnAttempts) {
                CobblemonAlphasMod.LOGGER.info("Maximum spawn attempts reached. Skipping this alpha spawn");
                return;
            }
            Optional<ServerPlayer> chosenPlayerOpt = players.stream().filter(player -> player.level().dimension() == Level.OVERWORLD).skip((int)((double)players.size() * Math.random())).findFirst();
            if (!chosenPlayerOpt.isPresent()) continue;
            chosenPlayer = chosenPlayerOpt.get();
            chosenPlayerSpawnLevel = chosenPlayer.level();
            spawnLocation = this.spawnLocationSelector.getSpawnLocation(chosenPlayer.level(), chosenPlayer.position());
            if (spawnLocation == null) continue;
            finalSpawnPos = new BlockPos(spawnLocation.getX(), spawnLocation.getY(), spawnLocation.getZ());
            if (!this.spawnConditions.stream().anyMatch(condition -> !condition.isSafe(chosenPlayerSpawnLevel, finalSpawnPos))) break;
        }
        Optional biomeKey = chosenPlayerSpawnLevel.getBiome(finalSpawnPos).unwrapKey();
        if (chosenPlayerSpawnLevel.canSeeSky(finalSpawnPos)) {
            Alpha tempAlpha2;
            if (biomeKey.isPresent() && (tempAlpha2 = AlphaJsonDataManager.getRandomAlphaForBiome(chosenPlayer.level(), (ResourceKey<Biome>)((ResourceKey)biomeKey.get()), false).values().stream().toList().getFirst()) != null) {
                chosenAlpha = tempAlpha2;
            }
        } else if (biomeKey.isPresent() && (tempAlpha = AlphaJsonDataManager.getRandomAlphaForBiome(chosenPlayer.level(), (ResourceKey<Biome>)((ResourceKey)biomeKey.get()), true).values().stream().toList().getFirst()) != null) {
            chosenAlpha = tempAlpha;
        }
        Vec3i spawnPos = spawnLocation;
        Level spawnLevel = chosenPlayerSpawnLevel;
        this.spawnAlphaEntity(chosenAlpha, spawnLevel, spawnPos, ModConfig.doHerdSpawning);
        Object announcement = ModConfig.spawnAnnouncementMessage;
        if (ModConfig.showCoordinatesInAnnouncement) {
            announcement = (String)announcement + " (" + spawnPos.getX() + ", " + spawnPos.getY() + ", " + spawnPos.getZ() + ")";
        }
        this.server.getPlayerList().broadcastSystemMessage((Component)Component.literal((String)announcement), false);
    }

    public void spawnAlphaEntity(Alpha alpha, Level level, Vec3i spawnPosition, boolean doHerdSpawning) {
        if (!level.isClientSide()) {
            PokemonEntity alphaEntity = this.generateAlpha(alpha, level, spawnPosition);
            level.getChunkAt(new BlockPos(spawnPosition));
            level.addFreshEntity((Entity)alphaEntity);
            if (doHerdSpawning) {
                this.spawnHerdPokemon(alphaEntity, alpha.getHerdMembers(), level, spawnPosition);
            }
        }
    }

    private PokemonEntity generateAlpha(Alpha chosenAlpha, Level spawnLevel, Vec3i spawnPos) {
        Pokemon pokemon = new Pokemon();
        pokemon.setSpecies(Objects.requireNonNull(PokemonSpecies.INSTANCE.getByName(chosenAlpha.getSpecies())));
        pokemon.setLevel(chosenAlpha.getLevelFromRange());
        pokemon.initializeMoveset(true);
        pokemon.setScaleModifier((float)ModConfig.alphaSizeMultiplier);
        pokemon.getPersistentData().putBoolean("IS_ALPHA", true);
        pokemon.getAspects().add("alpha");
        IVs ivs = pokemon.getIvs();
        pokemon.setIvs$common(AlphaSpawner.maximizeRandomIVs(ivs));
        pokemon.setAbility$common(this.doHiddenAbilityCheck(pokemon));
        if (Math.random() < 1.0 / (double)ModConfig.shinyOdds) {
            pokemon.setShiny(true);
        }
        PokemonEntity alphaEntity = new PokemonEntity(spawnLevel, pokemon, CobblemonEntities.POKEMON);
        alphaEntity.setDespawner((Despawner)AlphaDespawner.getInstance());
        alphaEntity.setPos((double)spawnPos.getX(), (double)spawnPos.getY(), (double)spawnPos.getZ());
        spawnLevel.getChunkAt(new BlockPos(spawnPos));
        return alphaEntity;
    }

    private void spawnHerdPokemon(PokemonEntity alphaEntity, List<HerdMember> herdMembers, Level spawnLevel, Vec3i spawnPos) {
        String alphaString = alphaEntity.getPokemon().getSpecies().getName();
        if (herdMembers.size() <= 0) {
            CobblemonAlphasMod.LOGGER.warn(String.format("Herd members for %s is empty. Skipping herd spawning for this alpha", alphaString));
            return;
        }
        for (int i = 1; i <= 4; ++i) {
            int random = new Random().nextInt(herdMembers.size());
            HerdMember herdMember = herdMembers.get(random);
            Pokemon herdMemberPokemon = new Pokemon();
            Species herdMemberSpecies = PokemonSpecies.INSTANCE.getByName(herdMember.getSpecies());
            if (herdMemberSpecies == null) {
                CobblemonAlphasMod.LOGGER.warn(String.format("Incorrect species defined for herd member of %s. %s is not a valid pokemon species", alphaString, herdMember.getSpecies()));
                return;
            }
            herdMemberPokemon.setSpecies(herdMemberSpecies);
            herdMemberPokemon.setLevel(herdMember.getLevelFromRange());
            herdMemberPokemon.initializeMoveset(true);
            herdMemberPokemon.getPersistentData().putUUID("ALPHA_ID", alphaEntity.getUUID());
            if (Math.random() < 1.0 / (double)ModConfig.shinyOdds) {
                herdMemberPokemon.setShiny(true);
            }
            PokemonEntity herdEntity = new PokemonEntity(spawnLevel, herdMemberPokemon, CobblemonEntities.POKEMON);
            herdEntity.setDespawner((Despawner)AlphaDespawner.getInstance());
            herdEntity.setPos((double)spawnPos.getX(), (double)spawnPos.getY(), (double)spawnPos.getZ());
            spawnLevel.getChunkAt(new BlockPos(spawnPos));
            spawnLevel.addFreshEntity((Entity)herdEntity);
        }
    }

    private Ability doHiddenAbilityCheck(Pokemon pokemon) {
        AbilityPool abilities = pokemon.getSpecies().getAbilities();
        ArrayList<AbilityTemplate> hiddenAbilities = new ArrayList<AbilityTemplate>();
        for (PotentialAbility potentialAbility : abilities) {
            if (potentialAbility.getPriority() != Priority.LOW) continue;
            hiddenAbilities.add(potentialAbility.getTemplate());
        }
        if (!hiddenAbilities.isEmpty() && Math.random() >= 0.6) {
            int selection = new Random().nextInt(hiddenAbilities.size());
            return new Ability((AbilityTemplate)hiddenAbilities.get(selection), false, Priority.NORMAL);
        }
        return pokemon.getAbility();
    }

    public static IVs maximizeRandomIVs(IVs ivs) {
        ArrayList<String> chosenStats = new ArrayList<String>(List.of(statNames));
        for (int i = 1; i <= ModConfig.maximumBestIVs; ++i) {
            int ivIndex = new Random().nextInt(chosenStats.size());
            String statName = (String)chosenStats.get(ivIndex);
            Stats stat = Stats.valueOf((String)statName);
            ivs.set((Stat)stat, 31);
            chosenStats.remove(statName);
        }
        return ivs;
    }
}

