/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.entity.spawner.spawnData.location;

import dev.cudzer.cobblemonalphas.entity.spawner.spawnData.location.ISpawnLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RandomSurfaceSpawn
implements ISpawnLocation {
    private final int minimumSpawnDistance;
    private final int maximumSpawnDistance;

    public RandomSurfaceSpawn(int minimumSpawnDistance, int maximumSpawnDistance) {
        this.minimumSpawnDistance = minimumSpawnDistance;
        this.maximumSpawnDistance = maximumSpawnDistance;
    }

    @Override
    @Nullable
    public Vec3i getSpawnLocation(Level level, Vec3 center) {
        double dist = (double)this.minimumSpawnDistance + (double)(this.maximumSpawnDistance - this.minimumSpawnDistance) * Math.random();
        double theta = Math.PI * 2 * Math.random();
        double x = center.x() + dist * Math.cos(theta);
        double z = center.z() + dist * Math.sin(theta);
        BlockPos blockPos = new BlockPos((int)x, level.getMaxBuildHeight() - 1, (int)z);
        while (level.getBlockState(blockPos).isAir() && level.isInWorldBounds(blockPos)) {
            blockPos = blockPos.below();
        }
        while (!level.getBlockState(blockPos).isAir() && level.isInWorldBounds(blockPos)) {
            blockPos = blockPos.above();
        }
        return level.isInWorldBounds(blockPos) ? new Vec3i((int)x, blockPos.getY(), (int)z) : null;
    }
}

