/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import dev.cudzer.cobblemonalphas.CobblemonAlphasMod;
import dev.cudzer.cobblemonalphas.IPlatform;
import dev.cudzer.cobblemonalphas.entity.spawner.AlphaSpawner;
import dev.cudzer.cobblemonalphas.particles.AlphaParticleEffect;
import java.nio.file.Path;
import net.minecraft.commands.CommandSourceStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@Mod(value="cobblemonalphas")
public final class CobblemonAlphasModNeoForge
implements IPlatform {
    public CobblemonAlphasModNeoForge() {
        NeoForge.EVENT_BUS.register((Object)this);
        CobblemonAlphasMod.init(this);
    }

    @Override
    public Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    @SubscribeEvent
    public void onCommandRegistration(RegisterCommandsEvent event) {
        CobblemonAlphasMod.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        try {
            AlphaSpawner.getInstance().tick();
            AlphaParticleEffect.tick(event.getServer());
        }
        catch (Throwable t) {
            CobblemonAlphasMod.LOGGER.warn("An exception occurred in the tick method for Cobblemon Alphas: {}", (Object)t.getMessage());
        }
    }

    @SubscribeEvent
    public void onServerStart(ServerStartedEvent event) {
        try {
            AlphaSpawner.getInstance().setServer(event.getServer());
            AlphaSpawner.getInstance().init();
        }
        catch (Throwable t) {
            CobblemonAlphasMod.LOGGER.warn("An exception occurred on the server start for Cobblemon Alphas: {}", (Object)t.getMessage());
        }
    }
}

