/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.cca.api.v3.component;

import io.netty.buffer.Unpooled;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7648;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.ComponentContainer;
import org.ladysnake.cca.api.v3.component.ComponentProvider;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.sync.ComponentPacketWriter;
import org.ladysnake.cca.api.v3.component.sync.PlayerSyncPredicate;
import org.ladysnake.cca.internal.base.ComponentsInternals;
import org.ladysnake.cca.internal.base.asm.CcaBootstrap;

@ApiStatus.NonExtendable
public abstract class ComponentKey<C extends Component> {
    private final class_2960 id;
    private final Class<C> componentClass;

    public final class_2960 getId() {
        return this.id;
    }

    public final Class<C> getComponentClass() {
        return this.componentClass;
    }

    @Contract(pure=true)
    @Nullable
    public C getNullable(Object provider) {
        return this.getInternal(((ComponentProvider)provider).getComponentContainer());
    }

    public final C get(Object provider) {
        C component = this.getInternal(((ComponentProvider)provider).getComponentContainer());
        assert (component == null || this.getComponentClass().isInstance(component));
        if (component == null) {
            try {
                throw new NoSuchElementException(String.valueOf(provider) + " provides no component of type " + String.valueOf(this.getId()));
            }
            catch (NullPointerException e) {
                NoSuchElementException e1 = new NoSuchElementException(String.valueOf(this.getId()) + " not available");
                e1.addSuppressed(e);
                throw e1;
            }
        }
        return component;
    }

    public final Optional<C> maybeGet(@Nullable Object provider) {
        if (provider instanceof ComponentProvider) {
            ComponentProvider p = (ComponentProvider)provider;
            return Optional.ofNullable(this.getInternal(p.getComponentContainer()));
        }
        return Optional.empty();
    }

    @Contract(pure=true)
    public boolean isProvidedBy(Object provider) {
        return this.getNullable(provider) != null;
    }

    public void sync(Object provider) {
        C c = this.get(provider);
        if (c instanceof AutoSyncedComponent) {
            AutoSyncedComponent synced = (AutoSyncedComponent)c;
            this.sync(provider, synced, synced);
        }
    }

    public void sync(Object provider, ComponentPacketWriter packetWriter) {
        C c = this.get(provider);
        if (c instanceof AutoSyncedComponent) {
            AutoSyncedComponent synced = (AutoSyncedComponent)c;
            this.sync(provider, packetWriter, synced);
        }
    }

    public void sync(Object provider, ComponentPacketWriter packetWriter, PlayerSyncPredicate predicate) {
        for (class_3222 player : ((ComponentProvider)provider).getRecipientsForComponentSync()) {
            this.syncWith(player, (ComponentProvider)provider, packetWriter, predicate);
        }
    }

    @ApiStatus.Experimental
    public void syncWith(class_3222 player, ComponentProvider provider) {
        C c = this.get(provider);
        if (c instanceof AutoSyncedComponent) {
            AutoSyncedComponent synced = (AutoSyncedComponent)c;
            this.syncWith(player, provider, synced, synced);
        }
    }

    @ApiStatus.Experimental
    public void syncWith(class_3222 player, ComponentProvider provider, ComponentPacketWriter writer, PlayerSyncPredicate predicate) {
        if (predicate.shouldSyncWith(player)) {
            class_9129 buf = new class_9129(Unpooled.buffer(), player.method_51469().method_30349());
            writer.writeSyncPacket(buf, player);
            class_8710 payload = provider.toComponentPacket(this, predicate.isRequiredOnClient(), buf);
            if (payload != null) {
                if (ServerPlayNetworking.canSend((class_3222)player, (class_8710.class_9154)payload.method_56479())) {
                    ServerPlayNetworking.getSender((class_3222)player).sendPacket(payload, class_7648.method_45084(() -> ((class_9129)buf).release()));
                } else {
                    if (predicate.isRequiredOnClient()) {
                        player.field_13987.method_52396((class_2561)class_2561.method_43470((String)("This server requires Cardinal Components API (unhandled packet: " + String.valueOf(payload.method_56479().comp_2242()) + ")" + ComponentsInternals.getClientOptionalModAdvice())));
                    }
                    buf.release();
                }
            } else {
                buf.release();
            }
        }
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "[\"" + String.valueOf(this.id) + "\"]";
    }

    @ApiStatus.Internal
    protected ComponentKey(class_2960 id, Class<C> componentClass) {
        if (!CcaBootstrap.INSTANCE.isGenerated(this.getClass())) {
            throw new IllegalStateException();
        }
        this.componentClass = componentClass;
        this.id = id;
    }

    @Contract(pure=true)
    @ApiStatus.Internal
    @Nullable
    public abstract C getInternal(ComponentContainer var1);

    @ApiStatus.Internal
    public C getFromContainer(ComponentContainer container) {
        return (C)((Component)Objects.requireNonNull(this.getInternal(container)));
    }
}

