/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.dynamic;

import com.mojang.serialization.Codec;
import dev.imb11.mru.RegistryUtils;
import dev.imb11.sounds.api.SoundDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.SoundType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicSoundHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicSoundHelper.class);
    protected static HashMap<String, Codec<?>> loadDirectories = new HashMap();
    protected static HashMap<String, ArrayList<?>> loadedDefinitions = new HashMap();

    protected static void declareDefinitionsToLoad(String directory, Codec<?> codec) {
        loadDirectories.put(directory, codec);
        loadedDefinitions.put(directory, new ArrayList());
    }

    protected static void clearDefinitions() {
        loadedDefinitions.values().forEach(ArrayList::clear);
    }

    public static void initialize() {
        DynamicSoundHelper.declareDefinitionsToLoad("items", SoundDefinition.getCodec(BuiltInRegistries.ITEM.key()));
        DynamicSoundHelper.declareDefinitionsToLoad("screens", SoundDefinition.getCodec(BuiltInRegistries.MENU.key()));
    }

    public static <T> ArrayList<SoundDefinition<T>> getDefinitions(String directory) {
        return loadedDefinitions.get(directory);
    }

    public static enum BlockSoundType {
        PLACE(t -> RegistryUtils.getId((SoundEvent)t.getPlaceSound())),
        HIT(t -> RegistryUtils.getId((SoundEvent)t.getHitSound())),
        BREAK(t -> RegistryUtils.getId((SoundEvent)t.getBreakSound())),
        FALL(t -> RegistryUtils.getId((SoundEvent)t.getFallSound())),
        STEP(t -> RegistryUtils.getId((SoundEvent)t.getStepSound()));

        private final Function<SoundType, ResourceLocation> transformer;

        private BlockSoundType(Function<SoundType, ResourceLocation> transformer) {
            this.transformer = transformer;
        }

        public Function<SoundType, ResourceLocation> getTransformer() {
            return this.transformer;
        }
    }
}

