/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.api.content.pipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import org.jetbrains.annotations.NotNull;
import org.jgrapht.Graph;
import org.jgrapht.ListenableGraph;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.alg.connectivity.GabowStrongConnectivityInspector;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DefaultListenableGraph;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import tv.soaryn.xycraft.api.content.capabilities.IPipeConnection;
import tv.soaryn.xycraft.api.content.pipes.EdgeData;
import tv.soaryn.xycraft.api.content.pipes.IPipeGraphInvalidator;
import tv.soaryn.xycraft.api.content.pipes.IPipeRouteFactory;
import tv.soaryn.xycraft.api.content.pipes.PipeGraph;
import tv.soaryn.xycraft.api.content.pipes.PipeNetwork;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;

public class PipeRoute<TCapability> {
    public final ListenableGraph<Long, EdgeData> RouteGraph = new DefaultListenableGraph((Graph)new SimpleDirectedWeightedGraph(EdgeData.class));
    public final Long2ObjectOpenHashMap<ObjectArraySet<Direction>> PosToValidExternalConnectionMap = new Long2ObjectOpenHashMap();
    public final transient Long2ObjectOpenHashMap<ObjectArraySet<CacheWrapper>> PosToExternalCaches = new Long2ObjectOpenHashMap();
    public final transient Long2ObjectOpenHashMap<BlockCapabilityCache<IPipeConnection, Void>> PosToPipeConnectionCache = new Long2ObjectOpenHashMap();
    public final transient ConnectivityInspector<Long, EdgeData> Inspector;
    public final transient BlockCapability<TCapability, Direction> Cap;
    public LongSet pipeChanges = new LongArraySet();
    public LongArraySet handlerChanges = new LongArraySet();
    protected IPipeGraphInvalidator _invalidator = () -> {};

    public static <TCapability> Codec<PipeRoute<TCapability>> codec(IPipeRouteFactory<TCapability> factory, BlockCapability<TCapability, Direction> cap) {
        return RecordCodecBuilder.create(builder -> builder.group((App)NeoForgeExtraCodecs.setOf((Codec)Codec.LONG).fieldOf("nodes").forGetter(data -> data.RouteGraph.vertexSet()), (App)NeoForgeExtraCodecs.setOf(EdgeData.CODEC).fieldOf("edges").forGetter(data -> data.RouteGraph.edgeSet()), (App)CodecUtils.tupleOf(Codec.LONG, NeoForgeExtraCodecs.setOf((Codec)Direction.CODEC).xmap(ObjectArraySet::new, ObjectArraySet::new), Long2ObjectOpenHashMap::new).fieldOf("external_connections").forGetter(data -> data.PosToValidExternalConnectionMap)).apply((Applicative)builder, (nodes, edges, validHandlers) -> factory.create((Set<Long>)nodes, (Set<EdgeData>)edges, (Long2ObjectOpenHashMap<ObjectArraySet<Direction>>)validHandlers, cap)));
    }

    public PipeRoute(BlockCapability<TCapability, Direction> cap) {
        this(Set.of(), Set.of(), (Long2ObjectMap<ObjectArraySet<Direction>>)Long2ObjectMaps.emptyMap(), cap);
    }

    public PipeRoute(Set<Long> nodes, Set<EdgeData> edges, Long2ObjectMap<ObjectArraySet<Direction>> posToValidExternalConnectionMap, BlockCapability<TCapability, Direction> cap) {
        this.Cap = cap;
        this.Inspector = new ConnectivityInspector(this.RouteGraph);
        this.RouteGraph.addGraphListener(this.Inspector);
        this.Inspector.connectedSets();
        this.PosToValidExternalConnectionMap.putAll(posToValidExternalConnectionMap);
        nodes.forEach(arg_0 -> this.RouteGraph.addVertex(arg_0));
        edges.forEach(edgeData -> {
            this.RouteGraph.addEdge((Object)edgeData.src(), (Object)edgeData.dst(), edgeData);
            this.RouteGraph.setEdgeWeight((Object)edgeData.src(), (Object)edgeData.dst(), (double)edgeData.weight());
        });
    }

    public Graph<Graph<Long, EdgeData>, DefaultEdge> getPipeGroups() {
        return new GabowStrongConnectivityInspector(this.RouteGraph).getCondensation();
    }

    public <TGraph extends PipeGraph<TCapability, TGraph>> void buildCaches(PipeNetwork<TGraph, TCapability> network, ServerLevel level, boolean loading) {
        this.PosToPipeConnectionCache.clear();
        Iterator iterator = this.RouteGraph.vertexSet().iterator();
        while (iterator.hasNext()) {
            long value = (Long)iterator.next();
            this.PosToPipeConnectionCache.put(value, this.createPipeCache(level, value));
            ObjectArraySet existingValid = (ObjectArraySet)this.PosToValidExternalConnectionMap.get(value);
            BlockPos pos = BlockPos.of((long)value);
            ObjectArraySet set = new ObjectArraySet();
            ObjectArraySet validDirs = new ObjectArraySet();
            for (Direction dir : Direction.values()) {
                boolean isPipe;
                CacheWrapper wrapper = new CacheWrapper(level, dir, pos);
                set.add((Object)wrapper);
                if (!loading && !level.shouldTickBlocksAt(pos.relative(dir))) {
                    if (existingValid == null || !existingValid.contains((Object)dir)) continue;
                    validDirs.add((Object)dir);
                    continue;
                }
                long posId = wrapper.Cache.pos().asLong();
                boolean bl = isPipe = network.PosToId().containsKey(posId) || this.RouteGraph.containsVertex((Object)posId);
                if (wrapper.Cache.getCapability() == null || isPipe) continue;
                validDirs.add((Object)dir);
            }
            ObjectArraySet existingCache = (ObjectArraySet)this.PosToExternalCaches.get(value);
            if (existingCache != null) {
                for (CacheWrapper prevCache : existingCache) {
                    prevCache.invalidate();
                }
            }
            this.PosToExternalCaches.put(value, (Object)set);
            if (loading || validDirs.isEmpty()) continue;
            this.PosToValidExternalConnectionMap.put(value, (Object)validDirs);
        }
    }

    public void removeAllNodes() {
        this.RouteGraph.removeAllVertices(Set.copyOf(this.RouteGraph.vertexSet()));
    }

    @NotNull
    private BlockCapabilityCache<TCapability, Direction> createCapCache(ServerLevel level, Direction direction, BlockPos pos) {
        long posId = pos.asLong();
        long otherPosId = pos.relative(direction).asLong();
        BlockCapabilityCache cache = BlockCapabilityCache.create(this.Cap, (ServerLevel)level, (BlockPos)pos.relative(direction), (Object)direction.getOpposite(), () -> this.RouteGraph.containsVertex((Object)posId), () -> {
            if (this.RouteGraph.containsVertex((Object)otherPosId)) {
                return;
            }
            this._invalidator.invalidate();
            this.handlerChanges.add(posId);
        });
        cache.getCapability();
        return cache;
    }

    @NotNull
    protected BlockCapabilityCache<IPipeConnection, Void> createPipeCache(ServerLevel level, long posId) {
        BlockPos pos = BlockPos.of((long)posId);
        BlockCapabilityCache capCache = BlockCapabilityCache.create(IPipeConnection.BLOCK, (ServerLevel)level, (BlockPos)pos, null, () -> this.RouteGraph.containsVertex((Object)posId), () -> {
            if (!level.shouldTickBlocksAt(pos)) {
                return;
            }
            this._invalidator.invalidate();
            this.pipeChanges.add(posId);
        });
        capCache.getCapability();
        return capCache;
    }

    public class CacheWrapper {
        public final BlockCapabilityCache<TCapability, Direction> Cache;
        private boolean _isValid = true;

        public void invalidate() {
            this._isValid = false;
        }

        public TCapability getCapability() {
            return this.Cache.getCapability();
        }

        public CacheWrapper(ServerLevel level, Direction direction, BlockPos pos) {
            long posId = pos.asLong();
            long otherPosId = pos.relative(direction).asLong();
            this.Cache = BlockCapabilityCache.create(PipeRoute.this.Cap, (ServerLevel)level, (BlockPos)pos.relative(direction), (Object)direction.getOpposite(), () -> this._isValid && PipeRoute.this.RouteGraph.containsVertex((Object)posId), () -> {
                if (PipeRoute.this.RouteGraph.containsVertex((Object)otherPosId)) {
                    return;
                }
                PipeRoute.this._invalidator.invalidate();
                PipeRoute.this.handlerChanges.add(posId);
            });
            this.Cache.getCapability();
        }
    }
}

