/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container.energy;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.container.energy.EnergyContainer;

public record EnergyContainerSlice(EnergyContainer parent, int start, int length) implements EnergyContainer
{
    @Override
    public int size() {
        return this.length;
    }

    @Override
    public int get(int slot) {
        Objects.checkIndex(slot, this.length);
        return this.parent.get(slot + this.start);
    }

    @Override
    public void set(int slot, int value) {
        Objects.checkIndex(slot, this.length);
        this.parent.set(slot + this.start, value);
    }

    @Override
    public int getCapacity(int slot) {
        return this.parent.getCapacity(slot);
    }

    @Override
    @NotNull
    public EnergyContainer slice(int from, int to) {
        Objects.checkFromToIndex(from, to, this.length);
        return new EnergyContainerSlice(this.parent, this.start + from, to - from);
    }
}

