/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.protocontainer;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.SoundAction;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.utils.protocontainer.IResource;
import tv.soaryn.xycraft.core.utils.protocontainer.ResourceStack;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;

public final class FluidResource
implements IResource,
DataComponentHolder {
    public static final Codec<FluidResource> CODEC = FluidStack.fixedAmountCodec((int)1).xmap(FluidResource::of, r -> r.toStack(1));
    public static final Codec<FluidResource> OPTIONAL_CODEC = ExtraCodecs.optionalEmptyMap(CODEC).xmap(o -> o.orElse(EMPTY), r -> r.isEmpty() ? Optional.of(EMPTY) : Optional.of(r));
    public static final Codec<ResourceStack<FluidResource>> OPTIONAL_WITH_AMOUNT_CODEC = CodecUtils.Codecs.FLUID_STACK_OPTIONAL.xmap(fluidStack -> new ResourceStack<FluidResource>(FluidResource.of(fluidStack), fluidStack.getAmount()), stack -> ((FluidResource)stack.resource()).toStack(stack.amount()));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidResource> OPTIONAL_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.FLUID), FluidResource::getFluidHolder, (StreamCodec)DataComponentPatch.STREAM_CODEC, FluidResource::getComponentsPatch, FluidResource::of);
    public static final FluidResource EMPTY = new FluidResource(FluidStack.EMPTY);
    public static final ResourceStack<FluidResource> EMPTY_STACK = new ResourceStack<FluidResource>(EMPTY, 0);
    private final FluidStack innerStack;

    public static FluidResource of(FluidStack fluidStack) {
        return fluidStack.isEmpty() ? EMPTY : new FluidResource(fluidStack.copyWithAmount(1));
    }

    public static FluidResource of(Fluid fluid) {
        return fluid == Fluids.EMPTY ? EMPTY : new FluidResource(new FluidStack(fluid, 1));
    }

    public static FluidResource of(Holder<Fluid> fluid, DataComponentPatch patch) {
        return fluid.value() == Fluids.EMPTY ? EMPTY : new FluidResource(new FluidStack(fluid, 1, patch));
    }

    private FluidResource(FluidStack innerStack) {
        this.innerStack = innerStack;
    }

    @Override
    public boolean isEmpty() {
        return this.innerStack.isEmpty();
    }

    public FluidResource applyPatch(DataComponentPatch patch) {
        FluidStack stack = this.innerStack.copy();
        stack.applyComponents(patch);
        return new FluidResource(stack);
    }

    public <D> FluidResource set(DataComponentType<D> type, D data) {
        FluidStack stack = this.innerStack.copy();
        stack.set(type, data);
        return new FluidResource(stack);
    }

    public FluidResource remove(DataComponentType<?> type) {
        FluidStack stack = this.innerStack.copy();
        stack.remove(type);
        return new FluidResource(stack);
    }

    public Fluid getFluid() {
        return this.innerStack.getFluid();
    }

    public Holder<Fluid> getFluidHolder() {
        return this.innerStack.getFluidHolder();
    }

    public FluidType getFluidType() {
        return this.innerStack.getFluidType();
    }

    @NotNull
    public DataComponentMap getComponents() {
        return this.innerStack.getComponents();
    }

    public DataComponentPatch getComponentsPatch() {
        return this.innerStack.getComponentsPatch();
    }

    public boolean matches(FluidStack stack) {
        return FluidStack.isSameFluidSameComponents((FluidStack)stack, (FluidStack)this.innerStack);
    }

    public FluidStack toStack(int amount) {
        return this.innerStack.copyWithAmount(amount);
    }

    public FluidStack toStack() {
        return this.toStack(1000);
    }

    public boolean is(TagKey<Fluid> tag) {
        return this.innerStack.is(tag);
    }

    public boolean is(Fluid fluid) {
        return this.innerStack.is(fluid);
    }

    public boolean is(Predicate<Holder<Fluid>> predicate) {
        return this.innerStack.is(predicate);
    }

    public boolean is(Holder<Fluid> holder) {
        return this.innerStack.is(holder);
    }

    public boolean is(HolderSet<Fluid> holders) {
        return this.innerStack.is(holders);
    }

    public boolean is(FluidType fluidType) {
        return this.innerStack.is(fluidType);
    }

    public boolean isVaporizedOnPlacement(Level level, BlockPos pos) {
        return this.innerStack.getFluidType().isVaporizedOnPlacement(level, pos, this.innerStack);
    }

    public void onVaporize(Player player, Level level, BlockPos pos) {
        this.innerStack.getFluidType().onVaporize(player, level, pos, this.innerStack);
    }

    public static boolean isSameFluid(FluidResource first, FluidResource other) {
        return first.is(other.getFluid());
    }

    @Nullable
    public SoundEvent getSound(SoundAction action) {
        return this.innerStack.getFluidType().getSound(this.innerStack, action);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FluidResource)) return false;
        FluidResource v = (FluidResource)obj;
        if (!FluidStack.isSameFluidSameComponents((FluidStack)v.innerStack, (FluidStack)this.innerStack)) return false;
        return true;
    }

    public int hashCode() {
        return FluidStack.hashFluidAndComponents((FluidStack)this.innerStack);
    }
}

