/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.protocontainer.energy;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import tv.soaryn.xycraft.core.utils.protocontainer.TransferAction;
import tv.soaryn.xycraft.core.utils.protocontainer.energy.IEnergyHandler;

public class ComponentEnergyStorage
implements IEnergyHandler.IEnergyHandlerModifiable {
    protected final MutableDataComponentHolder parent;
    protected final DataComponentType<Integer> energyComponent;
    protected final int capacity;
    protected final int maxReceive;
    protected final int maxExtract;

    public ComponentEnergyStorage(MutableDataComponentHolder parent, DataComponentType<Integer> energyComponent, int capacity, int maxReceive, int maxExtract) {
        this.parent = parent;
        this.energyComponent = energyComponent;
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public ComponentEnergyStorage(MutableDataComponentHolder parent, DataComponentType<Integer> energyComponent, int capacity, int maxTransfer) {
        this(parent, energyComponent, capacity, maxTransfer, maxTransfer);
    }

    public ComponentEnergyStorage(MutableDataComponentHolder parent, DataComponentType<Integer> energyComponent, int capacity) {
        this(parent, energyComponent, capacity, capacity);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public int insert(int index, int amount, TransferAction action) {
        if (!this.allowsInsertion(index) || amount <= 0) {
            return 0;
        }
        int energy = this.getAmount(index);
        int energyReceived = Mth.clamp((int)(this.capacity - energy), (int)0, (int)Math.min(this.maxReceive, amount));
        if (action.isExecuting() && energyReceived > 0) {
            this.set(index, energy + energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int insert(int amount, TransferAction action) {
        return this.insert(0, amount, action);
    }

    @Override
    public int extract(int index, int amount, TransferAction action) {
        if (!this.allowsExtraction() || amount <= 0) {
            return 0;
        }
        int energy = this.getAmount(index);
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, amount));
        if (action.isExecuting() && energyExtracted > 0) {
            this.set(index, energy - energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int extract(int amount, TransferAction action) {
        return this.extract(0, amount, action);
    }

    @Override
    public int getAmount(int index) {
        int rawEnergy = (Integer)this.parent.getOrDefault(this.energyComponent, (Object)0);
        return Mth.clamp((int)rawEnergy, (int)0, (int)this.capacity);
    }

    @Override
    public int getCapacity(int index) {
        return this.capacity;
    }

    @Override
    public boolean allowsInsertion() {
        return this.allowsInsertion(0);
    }

    @Override
    public boolean allowsExtraction() {
        return this.allowsExtraction(0);
    }

    @Override
    public boolean allowsExtraction(int index) {
        return this.maxExtract > 0;
    }

    @Override
    public boolean allowsInsertion(int index) {
        return this.maxReceive > 0;
    }

    @Override
    public void set(int index, int energy) {
        int realEnergy = Mth.clamp((int)energy, (int)0, (int)this.capacity);
        this.parent.set(this.energyComponent, (Object)realEnergy);
    }
}

