/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.camera.viewfinder;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.animation.Animation;
import io.github.mortuusars.exposure.client.animation.EasingFunction;
import io.github.mortuusars.exposure.client.camera.viewfinder.Viewfinder;
import io.github.mortuusars.exposure.client.camera.viewfinder.ViewfinderCameraControlsScreen;
import io.github.mortuusars.exposure.client.util.GuiUtil;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.util.Rect2f;
import io.github.mortuusars.exposure.util.UnixTimestamp;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.item.BrokenInterplanarProjectorItem;
import io.github.mortuusars.exposure.world.item.FilmRollItem;
import io.github.mortuusars.exposure.world.item.camera.Attachment;
import io.github.mortuusars.exposure.world.item.camera.CameraSettings;
import io.github.mortuusars.exposure.world.item.component.StoredItemStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ViewfinderOverlay {
    public static final ResourceLocation VIEWFINDER_TEXTURE = Exposure.resource("textures/gui/viewfinder/viewfinder.png");
    public static final ResourceLocation NO_FILM_ICON_TEXTURE = Exposure.resource("textures/gui/viewfinder/no_film.png");
    public static final ResourceLocation REMAINING_FRAMES_ICON_TEXTURE = Exposure.resource("textures/gui/viewfinder/remaining_frames.png");
    public static final ResourceLocation BSOD_SAD_FACE_TEXTURE = Exposure.resource("textures/gui/viewfinder/bsod_sad_face.png");
    public static final ResourceLocation BSOD_QR_CODE_TEXTURE = Exposure.resource("textures/gui/viewfinder/bsod_qr_code.png");
    protected final LocalPlayer player = Minecrft.player();
    protected final Camera camera;
    protected final Viewfinder viewfinder;
    protected final Rect2f opening;
    protected final Animation scaleAnimation;
    protected final float initialScale;
    protected int backgroundColor;
    protected float scale;
    protected float bobX = 0.0f;
    protected float bobY = 0.0f;
    protected float attackAnim = 0.0f;
    protected float xRot;
    protected float yRot;
    protected float xRot0;
    protected float yRot0;
    protected boolean forceDrawShutterOnNextFrame;
    protected long forceDrawShutterUntil = -1L;

    public ViewfinderOverlay(Camera camera, Viewfinder viewfinder) {
        this.camera = camera;
        this.viewfinder = viewfinder;
        this.backgroundColor = Config.getColor(Config.Client.VIEWFINDER_BACKGROUND_COLOR);
        this.opening = new Rect2f(0.0f, 0.0f, 0.0f, 0.0f);
        this.recalculateOpening();
        this.scaleAnimation = new Animation(300, EasingFunction.EASE_OUT_EXPO);
        this.initialScale = 0.5f;
        this.scale = 0.5f;
        this.xRot = Minecrft.get().gameRenderer.getMainCamera().getXRot();
        this.yRot = Minecrft.get().gameRenderer.getMainCamera().getYRot();
        this.xRot0 = this.xRot;
        this.yRot0 = this.yRot;
    }

    public Rect2f getOpening() {
        return this.opening;
    }

    public float getScale() {
        return this.scale;
    }

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        this.recalculateOpening();
        this.scale = Mth.lerp((float)((float)this.scaleAnimation.getValue()), (float)this.initialScale, (float)1.0f);
        if (!this.viewfinder.isLookingThrough() || Minecrft.options().hideGui || this.camera.isEmpty()) {
            return;
        }
        int width = Minecrft.get().getWindow().getGuiScaledWidth();
        int height = Minecrft.get().getWindow().getGuiScaledHeight();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)width / 2.0f, (float)height / 2.0f, 0.0f);
        guiGraphics.pose().scale(this.scale, this.scale, this.scale);
        if (((Boolean)Minecrft.options().bobView().get()).booleanValue()) {
            this.bobView(guiGraphics.pose(), deltaTracker);
        }
        this.applyAttackAnimation(guiGraphics.pose(), deltaTracker);
        this.applyMovementDelay(guiGraphics.pose(), deltaTracker);
        guiGraphics.pose().translate((float)(-width) / 2.0f, (float)(-height) / 2.0f, 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiUtil.drawRect(guiGraphics, this.opening.x, this.opening.y, -9999.0f, this.opening.height, this.backgroundColor);
        GuiUtil.drawRect(guiGraphics, this.opening.x + this.opening.width, this.opening.y, 9999.0f, this.opening.height, this.backgroundColor);
        GuiUtil.drawRect(guiGraphics, -4999.0f, this.opening.y, 9999.0f, -9999.0f, this.backgroundColor);
        GuiUtil.drawRect(guiGraphics, -4999.0f, this.opening.y + this.opening.height, 9999.0f, 9999.0f, this.backgroundColor);
        boolean drawGuide = true;
        StoredItemStack filter = Attachment.FILTER.get(this.camera.getItemStack());
        Item item = filter.getForReading().getItem();
        if (item instanceof BrokenInterplanarProjectorItem) {
            BrokenInterplanarProjectorItem brokenInterplanarProjector = (BrokenInterplanarProjectorItem)item;
            drawGuide = false;
            this.renderBSOD(guiGraphics, brokenInterplanarProjector, filter.getForReading());
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.drawShutter(guiGraphics);
        this.drawViewfinderTexture(guiGraphics);
        if (drawGuide) {
            ResourceLocation guideTexture = CameraSettings.COMPOSITION_GUIDE.getOrDefault(this.camera.getItemStack()).overlayTextureLocation();
            GuiUtil.blit(guideTexture, guiGraphics.pose(), this.opening, 0, 0, (int)this.opening.width, (int)this.opening.height, 0.0f);
        }
        if (!(Minecrft.get().screen instanceof ViewfinderCameraControlsScreen)) {
            this.renderStatusIcons(guiGraphics.pose(), this.camera.getItemStack());
        }
        guiGraphics.pose().popPose();
        RenderSystem.disableDepthTest();
    }

    protected void drawViewfinderTexture(GuiGraphics guiGraphics) {
        GuiUtil.blit(VIEWFINDER_TEXTURE, guiGraphics.pose(), this.opening, 0, 0, (int)this.opening.width, (int)this.opening.height, 0.0f);
    }

    protected void drawShutter(GuiGraphics guiGraphics) {
        if (this.camera.isShutterOpen() || this.forceDrawShutterOnNextFrame || this.forceDrawShutterUntil - System.currentTimeMillis() > 0L) {
            GuiUtil.drawRect(guiGraphics, this.opening, -98624229);
            this.forceDrawShutterOnNextFrame = false;
        }
    }

    public void startDrawingShutter() {
        this.forceDrawShutterOnNextFrame = true;
        this.forceDrawShutterUntil = UnixTimestamp.Milliseconds.now() + 100L;
    }

    protected void renderBSOD(GuiGraphics guiGraphics, BrokenInterplanarProjectorItem item, ItemStack stack) {
        Font font = Minecrft.get().font;
        int yCenter = (int)(this.opening.y + this.opening.height / 2.0f);
        Objects.requireNonNull(font);
        int margin = 9;
        int x = (int)(this.opening.x + this.opening.width * 0.125f);
        int y = yCenter;
        Objects.requireNonNull(font);
        int sadFaceSize = 9 * 5;
        guiGraphics.blit(BSOD_SAD_FACE_TEXTURE, x, y - sadFaceSize - margin, 0.0f, 0.0f, sadFaceSize, sadFaceSize, sadFaceSize, sadFaceSize);
        MutableComponent message = Component.translatable((String)"item.exposure.broken_interplanar_projector.viewfinder.message");
        List messageLines = font.split((FormattedText)message, (int)(this.opening.width * 0.75f));
        for (FormattedCharSequence line : messageLines) {
            guiGraphics.drawString(font, line, x, y, -1, false);
            Objects.requireNonNull(font);
            y += 9;
        }
        y += margin;
        int qrCodeTextureSize = 41;
        int qrCodeSize = switch ((int)Minecrft.get().getWindow().getGuiScale()) {
            case 1 -> qrCodeTextureSize * 3;
            case 2 -> qrCodeTextureSize * 2;
            default -> qrCodeTextureSize;
        };
        guiGraphics.blit(BSOD_QR_CODE_TEXTURE, x, y, 0.0f, 0.0f, qrCodeSize, qrCodeSize, qrCodeSize, qrCodeSize);
        MutableComponent errorCode = Component.translatable((String)"item.exposure.broken_interplanar_projector.viewfinder.error_code");
        guiGraphics.drawString(font, (Component)errorCode, x + qrCodeSize + margin, y, -1, false);
        Objects.requireNonNull(font);
        String code = item.getErrorCode(stack);
        guiGraphics.drawString(font, code, x + qrCodeSize + margin, y += 9, -1, false);
    }

    public void bobView(PoseStack poseStack, DeltaTracker deltaTracker) {
        Entity entity = Minecrft.get().getCameraEntity();
        if (entity instanceof Player) {
            Player pl = (Player)entity;
            float walkDist = Mth.lerp((float)deltaTracker.getGameTimeDeltaTicks(), (float)pl.walkDistO, (float)pl.walkDist);
            float strength = Mth.lerp((float)deltaTracker.getGameTimeDeltaTicks(), (float)pl.oBob, (float)pl.bob);
            float x = Mth.sin((float)(walkDist * (float)Math.PI)) * strength;
            float y = Math.abs(Mth.cos((float)(walkDist * (float)Math.PI)) * strength);
            float delta = Math.min(deltaTracker.getGameTimeDeltaTicks(), 1.0f);
            this.bobX = Mth.lerp((float)delta, (float)this.bobX, (float)x);
            this.bobY = Mth.lerp((float)delta, (float)this.bobY, (float)y);
            double guiScale = Minecrft.get().getWindow().getGuiScale();
            poseStack.translate((double)(this.bobX * 100.0f) / guiScale, (double)(this.bobY * 200.0f) / guiScale, 0.0);
            float scale = this.scale - this.bobY * 0.25f;
            poseStack.scale(scale, scale, scale);
        }
    }

    public void applyAttackAnimation(PoseStack poseStack, DeltaTracker deltaTracker) {
        float attack = this.player.attackAnim;
        if (attack > 0.1f) {
            attack = 1.0f - attack;
        }
        float delta = Math.min(deltaTracker.getGameTimeDeltaTicks(), 1.0f);
        this.attackAnim = Mth.lerp((float)delta, (float)this.attackAnim, (float)attack);
        poseStack.scale(1.0f - this.attackAnim * 0.1f, 1.0f - this.attackAnim * 0.2f, 1.0f - this.attackAnim * 0.1f);
        poseStack.mulPose(Axis.ZN.rotationDegrees(Mth.lerp((float)this.attackAnim, (float)0.0f, (float)5.0f)));
        double guiScale = Minecrft.get().getWindow().getGuiScale();
        poseStack.translate(0.0, 60.0 / guiScale * (double)this.attackAnim, 0.0);
    }

    public void applyMovementDelay(PoseStack poseStack, DeltaTracker deltaTracker) {
        float delta = Math.min(deltaTracker.getGameTimeDeltaTicks() * 0.6f, 1.0f);
        this.xRot0 = Mth.lerp((float)delta, (float)this.xRot0, (float)this.xRot);
        this.yRot0 = Mth.lerp((float)delta, (float)this.yRot0, (float)this.yRot);
        this.xRot = Minecrft.get().gameRenderer.getMainCamera().getXRot();
        this.yRot = Minecrft.get().gameRenderer.getMainCamera().getYRot();
        double guiScale = Minecrft.get().getWindow().getGuiScale();
        double horizontalDelay = (double)(this.yRot - this.yRot0) / guiScale * 3.0;
        double verticalDelay = (double)(this.xRot - this.xRot0) / guiScale * 3.0;
        poseStack.translate(-horizontalDelay, -verticalDelay, 0.0);
    }

    protected void recalculateOpening() {
        int width = Minecrft.get().getWindow().getGuiScaledWidth();
        int height = Minecrft.get().getWindow().getGuiScaledHeight();
        float openingSize = Math.min(width, height);
        this.opening.x = ((float)width - openingSize) / 2.0f;
        this.opening.y = ((float)height - openingSize) / 2.0f;
        this.opening.width = openingSize;
        this.opening.height = openingSize;
    }

    protected void renderStatusIcons(PoseStack poseStack, ItemStack cameraStack) {
        FilmRollItem filmRollItem;
        Item item;
        ItemStack filmStack = Attachment.FILM.get(cameraStack).getForReading();
        if (filmStack.isEmpty() || !((item = filmStack.getItem()) instanceof FilmRollItem) || !(filmRollItem = (FilmRollItem)item).canAddFrame(filmStack)) {
            this.renderNoFilmIcon(poseStack);
            return;
        }
        this.renderRemainingFramesIcon(poseStack, filmRollItem, filmStack);
    }

    protected void renderNoFilmIcon(PoseStack poseStack) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)NO_FILM_ICON_TEXTURE);
        int x = (int)(this.opening.x + this.opening.width / 2.0f - 12.0f) + (Integer)Config.Client.VIEWFINDER_STATUS_ICON_OFFSET_X.get();
        int y = (int)(this.opening.y + this.opening.height - 18.0f) + (Integer)Config.Client.VIEWFINDER_STATUS_ICON_OFFSET_Y.get();
        GuiUtil.blit(poseStack, (float)x, (float)y, 23.0f, 18.0f, 0, 0, 23, 18, 0.0f);
    }

    protected void renderRemainingFramesIcon(PoseStack poseStack, FilmRollItem filmRollItem, ItemStack filmStack) {
        int maxFrames = filmRollItem.getMaxFrameCount(filmStack);
        int exposedFrames = filmRollItem.getStoredFramesCount(filmStack);
        int remainingFrames = Math.max(0, maxFrames - exposedFrames);
        if (maxFrames > 5 && remainingFrames <= 3) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)REMAINING_FRAMES_ICON_TEXTURE);
            float x = (int)(this.opening.x + this.opening.width / 2.0f - 17.0f) + (Integer)Config.Client.VIEWFINDER_STATUS_ICON_OFFSET_X.get();
            float y = (int)(this.opening.y + this.opening.height - 15.0f) + (Integer)Config.Client.VIEWFINDER_STATUS_ICON_OFFSET_Y.get();
            int vOffset = (remainingFrames - 1) * 15;
            GuiUtil.blit(poseStack, x, y, 33.0f, 15.0f, 0, vOffset, 33, 45, 0.0f);
        }
    }
}

