/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen.element;

import io.github.mortuusars.exposure.client.gui.screen.element.textbox.HorizontalAlignment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextBlock
extends AbstractWidget {
    public int fontColor = -16777216;
    public boolean drawShadow = false;
    public HorizontalAlignment alignment = HorizontalAlignment.LEFT;
    private final Font font;
    private final Function<Style, Boolean> componentClickedHandler;
    private List<FormattedCharSequence> renderedLines;
    private List<FormattedCharSequence> tooltipLines;

    public TextBlock(Font font, int x, int y, int width, int height, Component message, Function<Style, Boolean> componentClickedHandler) {
        super(x, y, width, height, message);
        this.font = font;
        this.componentClickedHandler = componentClickedHandler;
        this.makeLines();
    }

    public void setMessage(Component message) {
        super.setMessage(message);
        this.makeLines();
    }

    protected void makeLines() {
        Component text = this.getMessage();
        List lines = this.font.split((FormattedText)text, this.getWidth());
        int n = lines.size();
        Objects.requireNonNull(this.font);
        int availableLines = Math.min(n, this.height / 9);
        ArrayList<FormattedCharSequence> visibleLines = new ArrayList<FormattedCharSequence>();
        for (int i = 0; i < availableLines; ++i) {
            FormattedCharSequence line = (FormattedCharSequence)lines.get(i);
            if (i == availableLines - 1 && availableLines < lines.size()) {
                line = FormattedCharSequence.composite((FormattedCharSequence)line, (FormattedCharSequence)Component.literal((String)"...").withStyle(text.getStyle()).getVisualOrderText());
            }
            visibleLines.add(line);
        }
        List hiddenLines = Collections.emptyList();
        if (availableLines < lines.size()) {
            hiddenLines = new ArrayList(lines.stream().skip(availableLines).toList());
            hiddenLines.set(0, FormattedCharSequence.composite((FormattedCharSequence)FormattedCharSequence.forward((String)"...", (Style)text.getStyle()), (FormattedCharSequence)((FormattedCharSequence)hiddenLines.get(0))));
        }
        this.renderedLines = visibleLines;
        this.tooltipLines = hiddenLines;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Style style = this.getClickedComponentStyleAt(mouseX, mouseY);
        return button == 0 && style != null && this.componentClickedHandler.apply(style) != false;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
    }

    @NotNull
    protected MutableComponent createNarrationMessage() {
        return this.getMessage().copy();
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Style style;
        for (int i = 0; i < this.renderedLines.size(); ++i) {
            FormattedCharSequence line = this.renderedLines.get(i);
            int x = this.getX() + this.alignment.align(this.getWidth(), this.font.width(line));
            int n = this.getY();
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, line, x, n + 9 * i, this.fontColor, this.drawShadow);
        }
        if (this.isHovered() && (style = this.getClickedComponentStyleAt(mouseX, mouseY)) != null) {
            guiGraphics.renderComponentHoverEffect(this.font, style, mouseX, mouseY);
        }
        if (!this.tooltipLines.isEmpty() && this.isMouseOver(mouseX, mouseY)) {
            guiGraphics.renderTooltip(this.font, this.tooltipLines, DefaultTooltipPositioner.INSTANCE, mouseX, mouseY);
        }
    }

    @Nullable
    public Style getClickedComponentStyleAt(double mouseX, double mouseY) {
        if (this.renderedLines.isEmpty()) {
            return null;
        }
        int x = Mth.floor((double)(mouseX - (double)this.getX()));
        int y = Mth.floor((double)(mouseY - (double)this.getY()));
        if (x < 0 || y < 0 || x > this.getWidth() || y > this.getHeight()) {
            return null;
        }
        Objects.requireNonNull(this.font);
        int hoveredLine = y / 9;
        if (hoveredLine >= this.renderedLines.size()) {
            return null;
        }
        FormattedCharSequence line = this.renderedLines.get(hoveredLine);
        int lineStart = this.alignment.align(this.getWidth(), this.font.width(line));
        if (x < lineStart) {
            return null;
        }
        return this.font.getSplitter().componentStyleAtWidth(line, x - lineStart);
    }
}

