/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.tooltip;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.world.entity.CameraStandEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class CameraStandTooltip {
    public static void render(GuiGraphics guiGraphics, DeltaTracker partialTick) {
        HitResult hitResult;
        if (!((Boolean)Config.Client.CAMERA_STAND_TOOLTIP.get()).booleanValue()) {
            return;
        }
        Minecraft minecraft = Minecrft.get();
        if (minecraft.options.hideGui) {
            return;
        }
        if (minecraft.level == null || minecraft.player == null) {
            return;
        }
        if (minecraft.screen != null || !((hitResult = minecraft.hitResult) instanceof EntityHitResult)) {
            return;
        }
        EntityHitResult entityHitResult = (EntityHitResult)hitResult;
        Entity entity = entityHitResult.getEntity();
        if (!(entity instanceof CameraStandEntity)) {
            return;
        }
        CameraStandEntity stand = (CameraStandEntity)entity;
        if (stand.getCamera().isEmpty()) {
            return;
        }
        int x = minecraft.getWindow().getGuiScaledWidth() / 2 + 16;
        int y = minecraft.getWindow().getGuiScaledHeight() / 2 - 9;
        if (stand.isMalfunctioned()) {
            List lines = Minecrft.get().font.split((FormattedText)Component.translatable((String)"gui.exposure.camera_stand.tooltip.malfunctioned").withStyle(ChatFormatting.RED), 230);
            guiGraphics.renderTooltip(minecraft.font, lines, x, y + 12);
        } else {
            TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)x, (int)y, (int)18, (int)18, (int)400);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 400.0f);
            guiGraphics.renderItem(stand.getCamera(), x + 1, y + 1);
            guiGraphics.pose().popPose();
            guiGraphics.renderTooltip(minecraft.font, stand.getCamera(), x + 16, y + 12);
        }
    }
}

