/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.render.model;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeModel
implements BakedModel {
    private final List<BakedModel> models;

    public CompositeModel(List<BakedModel> models) {
        this.models = models;
    }

    public CompositeModel(BakedModel ... models) {
        this.models = List.of(models);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, RandomSource random) {
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        for (BakedModel model : this.models) {
            list.addAll(model.getQuads(state, direction, random));
        }
        return list;
    }

    public boolean useAmbientOcclusion() {
        return this.models.getFirst().useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.models.getFirst().isGui3d();
    }

    public boolean usesBlockLight() {
        return this.models.getFirst().usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.models.getFirst().isCustomRenderer();
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon() {
        return this.models.getFirst().getParticleIcon();
    }

    @NotNull
    public ItemTransforms getTransforms() {
        return this.models.getFirst().getTransforms();
    }

    @NotNull
    public ItemOverrides getOverrides() {
        return this.models.getFirst().getOverrides();
    }
}

