/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.render.photograph;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.client.render.photograph.PhotographStyle;
import io.github.mortuusars.exposure.world.photograph.PhotographType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhotographStyles {
    private static final Map<PhotographType, PhotographStyle> STYLES = new HashMap<PhotographType, PhotographStyle>();

    public static void register(PhotographType photographType, PhotographStyle style) {
        Preconditions.checkState((!STYLES.containsKey(photographType) ? 1 : 0) != 0, (String)"PhotographStyle for type '%s' is already registered.", (Object)photographType);
        STYLES.put(photographType, style);
    }

    @NotNull
    public static PhotographStyle get(PhotographType type) {
        @Nullable PhotographStyle style = STYLES.get(type);
        Preconditions.checkNotNull((Object)style, (Object)"Type '%s' does not have a registered style.");
        return style;
    }
}

