/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.commands.exposure;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.clientbound.CaptureStartS2CP;
import io.github.mortuusars.exposure.world.camera.capture.CaptureParameters;
import io.github.mortuusars.exposure.world.camera.capture.CaptureType;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.level.storage.ExposureIdentifier;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class LoadCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        return (LiteralArgumentBuilder)Commands.literal((String)"load").then(Commands.argument((String)"capture_properties", (ArgumentType)CompoundTagArgument.compoundTag()).executes(context -> LoadCommand.load((CommandContext<CommandSourceStack>)context, CompoundTagArgument.getCompoundTag((CommandContext)context, (String)"capture_properties"))));
    }

    private static int load(CommandContext<CommandSourceStack> context, CompoundTag properties) throws CommandSyntaxException {
        CaptureParameters captureParameters;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        if (!properties.contains("id", 8)) {
            properties.putString("id", ExposureIdentifier.createId((Entity)player, new String[0]));
        }
        try {
            RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)((CommandSourceStack)context.getSource()).registryAccess());
            captureParameters = (CaptureParameters)((Pair)CaptureParameters.CODEC.decode((DynamicOps)ops, (Object)properties).getOrThrow()).getFirst();
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Cannot decode properties: " + e.getMessage())));
            return 0;
        }
        if (captureParameters.projection().isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Cannot load: missing 'projection' property."));
            return 0;
        }
        String exposureId = captureParameters.exposureId();
        Frame frame = Frame.EMPTY.toMutable().setIdentifier(ExposureIdentifier.id(exposureId)).toImmutable();
        Supplier<Component> msg = () -> {
            ItemStack photograph = new ItemStack((ItemLike)Exposure.Items.PHOTOGRAPH.get());
            photograph.set(Exposure.DataComponents.PHOTOGRAPH_FRAME, (Object)frame);
            return Component.literal((String)"Loaded exposure: ").append((Component)Component.literal((String)exposureId).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/exposure show id " + exposureId)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(photograph))).withUnderlined(Boolean.valueOf(true))));
        };
        ExposureServer.exposureRepository().expect(player, exposureId, (pl, id) -> ((CommandSourceStack)context.getSource()).sendSuccess(msg, true));
        ExposureServer.frameHistory().add((Entity)player, frame);
        Packets.sendToClient(new CaptureStartS2CP(CaptureType.LOAD_COMMAND, captureParameters), player);
        return 0;
    }
}

