/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.neoforge;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.neoforged.fml.loading.LoadingModList;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class ExposureMixinPlugin
implements IMixinConfigPlugin {
    private static final Map<String, Supplier<Boolean>> CONDITIONS = ImmutableMap.of((Object)"io.github.mortuusars.exposure.forge.mixin.create.CreateJEICompatMixin", ExposureMixinPlugin::isCorrectCreateVersion, (Object)"io.github.mortuusars.exposure.fabric.mixin.create.SpoutDevelopingMixin", ExposureMixinPlugin::isCorrectCreateVersion);

    private static boolean isCorrectCreateVersion() {
        return LoadingModList.get().getMods().stream().filter(i -> i.getModId().equals("create")).limit(1L).findFirst().map(c -> c.getVersion().toString().startsWith("0.5.1.f")).orElse(false);
    }

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return CONDITIONS.getOrDefault(mixinClassName, () -> true).get();
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

