/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.util.cycles.task;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.util.TranslatableError;
import io.github.mortuusars.exposure.util.cycles.task.NestedTask;
import io.github.mortuusars.exposure.util.cycles.task.Result;
import io.github.mortuusars.exposure.util.cycles.task.Task;
import io.github.mortuusars.exposure.util.cycles.task.TaskStoppedException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class HandleErrorTask<T>
extends NestedTask<T> {
    private final Consumer<TranslatableError> errorConsumer;

    public HandleErrorTask(Task<T> task, Consumer<TranslatableError> errorConsumer) {
        super(task);
        this.errorConsumer = errorConsumer;
    }

    @Override
    public CompletableFuture<T> execute() {
        return ((CompletableFuture)this.getTask().execute().exceptionally(throwable -> {
            this.errorConsumer.accept(TranslatableError.GENERIC);
            Exposure.LOGGER.error("Task threw an exception: ", throwable);
            throw new TaskStoppedException();
        })).thenApply(executionResult -> {
            Result result;
            if (executionResult instanceof Result && (result = (Result)executionResult).isError()) {
                Exposure.LOGGER.error(result.getError().technical().getString());
                this.errorConsumer.accept(result.getError());
                throw new TaskStoppedException();
            }
            return executionResult;
        });
    }
}

