/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item.camera;

import com.mojang.serialization.Codec;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.serverbound.ActiveCameraSetSettingC2SP;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import io.github.mortuusars.exposure.world.item.camera.CameraSettings;
import io.github.mortuusars.exposure.world.sound.Sound;
import io.github.mortuusars.exposure.world.sound.SoundEffect;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record CameraSetting<T>(DataComponentType<T> component, T defaultValue, Optional<SoundEffect> sound) {
    public static final Codec<CameraSetting<?>> CODEC = ResourceLocation.CODEC.xmap(CameraSettings::byId, CameraSettings::idOf);
    public static final StreamCodec<ByteBuf, CameraSetting<?>> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, CameraSettings::idOf, CameraSettings::byId);

    public CameraSetting(DataComponentType<T> component, T defaultValue, SoundEffect sound) {
        this(component, defaultValue, Optional.ofNullable(sound));
    }

    public CameraSetting(DataComponentType<T> component, T defaultValue) {
        this(component, defaultValue, Optional.empty());
    }

    @Nullable
    public T get(ItemStack stack) {
        return (T)stack.get(this.component);
    }

    public Optional<T> getOptional(ItemStack stack) {
        return Optional.ofNullable(this.get(stack));
    }

    public T getOrDefault(ItemStack stack) {
        return (T)stack.getOrDefault(this.component, this.defaultValue);
    }

    public T getOrElse(ItemStack stack, T defaultValue) {
        return (T)stack.getOrDefault(this.component, defaultValue);
    }

    @Nullable
    public T get(Camera camera) {
        return (T)camera.getItemStack().get(this.component);
    }

    public Optional<T> getOptional(Camera camera) {
        return Optional.ofNullable(this.get(camera));
    }

    public T getOrDefault(Camera camera) {
        return (T)camera.getItemStack().getOrDefault(this.component, this.defaultValue);
    }

    public T getOrElse(Camera camera, T defaultValue) {
        return (T)camera.getItemStack().getOrDefault(this.component, defaultValue);
    }

    public boolean set(ItemStack stack, T value) {
        Boolean bool;
        if (stack.isEmpty() || this.getOrDefault(stack).equals(value)) {
            return false;
        }
        if (value instanceof Boolean && !(bool = (Boolean)value).booleanValue()) {
            stack.remove(this.component);
        } else {
            stack.set(this.component, value);
        }
        return true;
    }

    public boolean set(CameraHolder holder, ItemStack stack, T value) {
        Item item = stack.getItem();
        if (item instanceof CameraItem) {
            CameraItem cameraItem = (CameraItem)item;
            if (this.set(stack, value)) {
                cameraItem.actionPerformed(stack, holder);
                this.sound.ifPresent(sound -> Sound.playSided(holder.asHolderEntity(), sound.sound().get(), SoundSource.PLAYERS, sound.volume(), sound.pitch(), sound.pitchVariability()));
                return true;
            }
        }
        return false;
    }

    public boolean set(Camera camera, T value) {
        return camera.map((item, stack) -> this.set(camera.getHolder(), (ItemStack)stack, value)).orElse(false);
    }

    public boolean setAndSync(Camera camera, T value) {
        return camera.map((item, stack) -> {
            if (this.set(camera.getHolder(), (ItemStack)stack, value)) {
                byte[] bytes = this.encodeValue(camera.getHolder().asHolderEntity().registryAccess(), value);
                Packets.sendToServer(new ActiveCameraSetSettingC2SP(this, bytes));
                return true;
            }
            return false;
        }).orElse(false);
    }

    public boolean decodeAndSet(ItemStack stack, RegistryAccess registryAccess, byte[] bytes) {
        T value = this.decodeValue(registryAccess, bytes);
        return this.set(stack, value);
    }

    public boolean decodeAndSet(CameraHolder holder, ItemStack stack, RegistryAccess registryAccess, byte[] bytes) {
        T value = this.decodeValue(registryAccess, bytes);
        return this.set(holder, stack, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encodeValue(RegistryAccess registryAccess, T value) {
        RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), registryAccess);
        try {
            this.component.streamCodec().encode((Object)buffer, value);
            byte[] byArray = (byte[])buffer.array().clone();
            return byArray;
        }
        finally {
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T decodeValue(RegistryAccess registryAccess, byte[] bytes) {
        RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), registryAccess);
        try {
            buffer.writeBytes(bytes);
            Object object = this.component.streamCodec().decode((Object)buffer);
            return (T)object;
        }
        finally {
            buffer.release();
        }
    }
}

