/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.level.storage;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.data.ColorPalettes;
import io.github.mortuusars.exposure.util.Codecs;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class ExposureData
extends SavedData {
    public static final Codec<ExposureData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("width").forGetter(ExposureData::getWidth), (App)Codec.INT.fieldOf("height").forGetter(ExposureData::getHeight), (App)Codecs.byteArrayCodec(1, 0x400000).fieldOf("pixels").forGetter(ExposureData::getPixels), (App)ResourceLocation.CODEC.optionalFieldOf("palette", (Object)ColorPalettes.DEFAULT.location()).forGetter(ExposureData::getPaletteId), (App)Tag.CODEC.optionalFieldOf("tag", (Object)Tag.EMPTY).forGetter(ExposureData::getTag)).apply((Applicative)instance, ExposureData::new));
    public static final StreamCodec<ByteBuf, ExposureData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ExposureData::getWidth, (StreamCodec)ByteBufCodecs.VAR_INT, ExposureData::getHeight, (StreamCodec)ByteBufCodecs.byteArray((int)0x400000), ExposureData::getPixels, (StreamCodec)ResourceLocation.STREAM_CODEC, ExposureData::getPaletteId, Tag.STREAM_CODEC, ExposureData::getTag, ExposureData::new);
    public static final ExposureData EMPTY = new ExposureData(1, 1, new byte[]{0}, ColorPalettes.DEFAULT.location(), Tag.EMPTY);
    private final int width;
    private final int height;
    private final byte[] pixels;
    private final ResourceLocation palette;
    private final Tag tag;

    public ExposureData(int width, int height, byte[] pixels, ResourceLocation paletteId, Tag tag) {
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0, (String)"Width should be larger than 0. %s", (int)width);
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0, (String)"Height should be larger than 0. %s ", (int)height);
        Preconditions.checkArgument((pixels.length == width * height ? 1 : 0) != 0, (String)"Pixel count '%s' is not correct for image dimensions of '%sx%s'. Count should be '%s'.", (Object)pixels.length, (Object)width, (Object)height, (Object)(width * height));
        this.width = width;
        this.height = height;
        this.pixels = pixels;
        this.palette = paletteId;
        this.tag = tag;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getPixels() {
        return this.pixels;
    }

    public byte getPixel(int x, int y) {
        return this.pixels[y * this.width + x];
    }

    public ResourceLocation getPaletteId() {
        return this.palette;
    }

    public Tag getTag() {
        return this.tag;
    }

    public ExposureData withTag(Function<Tag, Tag> updateFunction) {
        return new ExposureData(this.width, this.height, this.pixels, this.palette, (Tag)updateFunction.apply((Object)this.tag));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ExposureData that = (ExposureData)((Object)o);
        return this.width == that.width && this.height == that.height && Objects.deepEquals(this.pixels, that.pixels) && Objects.equals(this.palette, that.palette) && Objects.equals(this.tag, that.tag);
    }

    public int hashCode() {
        return Objects.hash(this.width, this.height, Arrays.hashCode(this.pixels), this.palette, this.tag);
    }

    @NotNull
    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        DataResult encodingResult = CODEC.encode((Object)this, (DynamicOps)NbtOps.INSTANCE, (Object)tag);
        if (encodingResult.isSuccess()) {
            net.minecraft.nbt.Tag encodedTag = (net.minecraft.nbt.Tag)encodingResult.getOrThrow();
            if (encodedTag instanceof CompoundTag) {
                CompoundTag encodedCompoundTag = (CompoundTag)encodedTag;
                return encodedCompoundTag;
            }
            Exposure.LOGGER.error("Cannot save PalettedExposure: '{}'. Encoded tag is not CompoundTag but a {}", (Object)this, (Object)encodedTag.getType());
        }
        encodingResult.error().ifPresent(error -> Exposure.LOGGER.error("Cannot save PalettedExposure: {}", (Object)error.message()));
        return tag;
    }

    public static SavedData.Factory<ExposureData> factory() {
        return new SavedData.Factory(() -> {
            throw new IllegalStateException("Should never create an empty exposure saved data");
        }, ExposureData::load, null);
    }

    public static ExposureData load(CompoundTag tag, HolderLookup.Provider levelRegistry) {
        return (ExposureData)((Object)((Pair)CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag).getOrThrow()).getFirst());
    }

    public record Tag(ExposureType type, String creator, long unixTimestamp, boolean loaded, boolean wasPrinted) {
        public static final Codec<Tag> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExposureType.CODEC.optionalFieldOf("type", (Object)ExposureType.COLOR).forGetter(Tag::type), (App)Codec.STRING.optionalFieldOf("creator", (Object)"").forGetter(Tag::creator), (App)Codec.LONG.optionalFieldOf("timestamp", (Object)1645494000L).forGetter(Tag::unixTimestamp), (App)Codec.BOOL.optionalFieldOf("loaded", (Object)false).forGetter(Tag::loaded), (App)Codec.BOOL.optionalFieldOf("was_printed", (Object)false).forGetter(Tag::wasPrinted)).apply((Applicative)instance, Tag::new));
        public static final StreamCodec<ByteBuf, Tag> STREAM_CODEC = new StreamCodec<ByteBuf, Tag>(){

            @NotNull
            public Tag decode(ByteBuf buffer) {
                return new Tag((ExposureType)((Object)ExposureType.STREAM_CODEC.decode((Object)buffer)), (String)ByteBufCodecs.STRING_UTF8.decode((Object)buffer), (Long)ByteBufCodecs.VAR_LONG.decode((Object)buffer), (Boolean)ByteBufCodecs.BOOL.decode((Object)buffer), (Boolean)ByteBufCodecs.BOOL.decode((Object)buffer));
            }

            public void encode(ByteBuf buffer, Tag data) {
                ExposureType.STREAM_CODEC.encode((Object)buffer, (Object)data.type());
                ByteBufCodecs.STRING_UTF8.encode((Object)buffer, (Object)data.creator());
                ByteBufCodecs.VAR_LONG.encode((Object)buffer, (Object)data.unixTimestamp());
                ByteBufCodecs.BOOL.encode((Object)buffer, (Object)data.loaded());
                ByteBufCodecs.BOOL.encode((Object)buffer, (Object)data.wasPrinted());
            }
        };
        public static final Tag EMPTY = new Tag(ExposureType.COLOR, "", 0L, false, false);

        public Tag withType(ExposureType type) {
            return new Tag(type, this.creator, this.unixTimestamp, this.loaded, this.wasPrinted);
        }

        public Tag withCreator(String creator) {
            return new Tag(this.type, creator, this.unixTimestamp, this.loaded, this.wasPrinted);
        }

        public Tag withTimestamp(long unixTimestamp) {
            return new Tag(this.type, this.creator, unixTimestamp, this.loaded, this.wasPrinted);
        }

        public Tag withLoadedSetTo(boolean isLoaded) {
            return new Tag(this.type, this.creator, this.unixTimestamp, isLoaded, this.wasPrinted);
        }

        public Tag withWasPrintedSetTo(boolean wasPrinted) {
            return new Tag(this.type, this.creator, this.unixTimestamp, this.loaded, wasPrinted);
        }

        public Tag setPrinted() {
            return new Tag(this.type, this.creator, this.unixTimestamp, this.loaded, true);
        }
    }
}

