/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.level.storage;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class ExposureFrameHistory
extends SavedData {
    public static final Codec<ExposureFrameHistory> CODEC = Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, (Codec)Codec.list(Frame.CODEC)).stable().xmap(ExposureFrameHistory::new, ExposureFrameHistory::getFrames);
    public static final int LIMIT = 32;
    private final Map<UUID, List<Frame>> frames;

    public ExposureFrameHistory(Map<UUID, List<Frame>> frames) {
        this.frames = new HashMap<UUID, List<Frame>>(frames);
    }

    public Map<UUID, List<Frame>> getFrames() {
        return this.frames;
    }

    public List<Frame> getFramesOf(Entity entity) {
        return this.getFramesOf(entity.getUUID());
    }

    public List<Frame> getFramesOf(UUID uuid) {
        return this.frames.getOrDefault(uuid, Collections.emptyList());
    }

    public void add(Entity entity, Frame frame) {
        this.add(entity.getUUID(), frame);
    }

    public void add(UUID uuid, Frame frame) {
        List list = this.frames.compute(uuid, (id, framesList) -> framesList == null ? new ArrayList() : new ArrayList(framesList));
        while (list.size() >= 32) {
            list.removeFirst();
        }
        list.add(frame);
        this.setDirty();
    }

    public void clear() {
        this.frames.clear();
    }

    public void clearOf(Entity entity) {
        this.frames.remove(entity.getUUID());
    }

    @NotNull
    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        DataResult encodingResult = CODEC.encode((Object)this, (DynamicOps)NbtOps.INSTANCE, (Object)tag);
        if (encodingResult.isSuccess()) {
            Tag encodedTag = (Tag)encodingResult.getOrThrow();
            if (encodedTag instanceof CompoundTag) {
                CompoundTag encodedCompoundTag = (CompoundTag)encodedTag;
                return encodedCompoundTag;
            }
            Exposure.LOGGER.error("Cannot save FramesHistory: '{}'. Encoded tag is not CompoundTag but a {}", (Object)this, (Object)encodedTag.getType());
        }
        encodingResult.error().ifPresent(error -> Exposure.LOGGER.error("Cannot save FramesHistory: {}", (Object)error.message()));
        return tag;
    }

    public static SavedData.Factory<ExposureFrameHistory> factory() {
        return new SavedData.Factory(() -> new ExposureFrameHistory(new HashMap<UUID, List<Frame>>()), ExposureFrameHistory::load, null);
    }

    public static ExposureFrameHistory load(CompoundTag tag, HolderLookup.Provider levelRegistry) {
        return (ExposureFrameHistory)((Object)((Pair)CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag).getOrThrow()).getFirst());
    }

    @NotNull
    public static ExposureFrameHistory loadOrCreate(MinecraftServer server) {
        return (ExposureFrameHistory)server.overworld().getDataStorage().computeIfAbsent(ExposureFrameHistory.factory(), "exposure_frame_history");
    }
}

