/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.codecs.bounds;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.exceptions.UtilityClassException;
import java.util.function.Function;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;

public final class UniformedNumberCodecs {
    public static final Codec<UniformFloat> FLOAT_CODEC = UniformedNumberCodecs.getFloatCodec();
    public static final Codec<UniformInt> INT_CODEC = UniformedNumberCodecs.getIntCodec();

    private UniformedNumberCodecs() throws UtilityClassException {
        throw new UtilityClassException();
    }

    private static Codec<UniformFloat> getFloatCodec() {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("min").forGetter(UniformFloat::getMinValue), (App)Codec.FLOAT.fieldOf("max").forGetter(UniformFloat::getMaxValue)).apply((Applicative)instance, UniformFloat::of));
        return codec.comapFlatMap(uniformFloat -> {
            if (uniformFloat.getMaxValue() < uniformFloat.getMinValue()) {
                return DataResult.error(() -> "Max must be at least min, min: " + uniformFloat.getMinValue() + ", max: " + uniformFloat.getMaxValue());
            }
            return DataResult.success((Object)uniformFloat);
        }, Function.identity());
    }

    public static Codec<UniformInt> getIntCodec() {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("min").forGetter(UniformInt::getMinValue), (App)Codec.INT.fieldOf("max").forGetter(UniformInt::getMaxValue)).apply((Applicative)instance, UniformInt::of));
        return codec.comapFlatMap(uniformInt -> {
            if (uniformInt.getMaxValue() < uniformInt.getMinValue()) {
                return DataResult.error(() -> "Max must be at least min, min: " + uniformInt.getMinValue() + ", max: " + uniformInt.getMaxValue());
            }
            return DataResult.success((Object)uniformInt);
        }, Function.identity());
    }

    public static Codec<UniformInt> rangedUniformIntCodec(int min, int max) {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)min, (int)max).fieldOf("min").forGetter(UniformInt::getMinValue), (App)Codec.intRange((int)min, (int)max).fieldOf("max").forGetter(UniformInt::getMaxValue)).apply((Applicative)instance, UniformInt::of));
        return codec.comapFlatMap(uniformInt -> {
            if (uniformInt.getMaxValue() < uniformInt.getMinValue()) {
                return DataResult.error(() -> "Max must be at least min, min: " + uniformInt.getMinValue() + ", max: " + uniformInt.getMaxValue());
            }
            return DataResult.success((Object)uniformInt);
        }, Function.identity());
    }

    public static Codec<UniformFloat> rangedUniformFloatCodec(float min, float max) {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)min, (float)max).fieldOf("min").forGetter(UniformFloat::getMinValue), (App)Codec.floatRange((float)min, (float)max).fieldOf("max").forGetter(UniformFloat::getMaxValue)).apply((Applicative)instance, UniformFloat::of));
        return codec.comapFlatMap(uniformFloat -> {
            if (uniformFloat.getMaxValue() < uniformFloat.getMinValue()) {
                return DataResult.error(() -> "Max must be at least min, min: " + uniformFloat.getMinValue() + ", max: " + uniformFloat.getMaxValue());
            }
            return DataResult.success((Object)uniformFloat);
        }, Function.identity());
    }
}

