/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.book;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonParseException;
import io.wispforest.lavender.Lavender;
import io.wispforest.lavender.book.BookLoader;
import io.wispforest.lavender.book.Category;
import io.wispforest.lavender.book.Entry;
import io.wispforest.lavender.book.LavenderClientStorage;
import io.wispforest.owo.ui.core.Sizing;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Book {
    private static final Pattern MACRO_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9_-]+");
    private static final Pattern MACRO_ARG_PATTERN = Pattern.compile("\\$\\d+");
    private final ResourceLocation id;
    @Nullable
    private final ResourceLocation texture;
    @Nullable
    private final ResourceLocation dynamicBookModel;
    @Nullable
    private final Component dynamicBookName;
    private final SoundEvent openSound;
    private final SoundEvent flippingSound;
    @Nullable
    private final ResourceLocation introEntry;
    private final boolean displayUnreadEntryNotifications;
    private final boolean displayCompletion;
    @Nullable
    private final ToastSettings newEntriesToast;
    private final Map<String, String> zeroArgMacros = new HashMap<String, String>();
    private final Map<Pattern, Macro> macros = new HashMap<Pattern, Macro>();
    @Nullable
    private final ResourceLocation extend;
    @Nullable
    private Book resolvedExtend = null;
    private final Map<ResourceLocation, Category> categories = new HashMap<ResourceLocation, Category>();
    private final Collection<Category> categoriesView = Collections.unmodifiableCollection(this.categories.values());
    private final Map<ResourceLocation, Entry> entriesById = new HashMap<ResourceLocation, Entry>();
    private final Collection<Entry> entriesView = Collections.unmodifiableCollection(this.entriesById.values());
    private final Map<Category, List<Entry>> entriesByCategory = new HashMap<Category, List<Entry>>();
    private final Multimap<Item, Entry> entriesByAssociatedItem = HashMultimap.create();
    private final List<Entry> orphanedEntries = new ArrayList<Entry>();
    private final Collection<Entry> orphanedEntriesView = Collections.unmodifiableCollection(this.orphanedEntries);
    @Nullable
    private Entry landingPage = null;

    public Book(ResourceLocation id, @Nullable ResourceLocation extend, @Nullable ResourceLocation texture, @Nullable ResourceLocation dynamicBookModel, @Nullable Component dynamicBookName, @Nullable SoundEvent openSound, @Nullable SoundEvent flippingSound, @Nullable ResourceLocation introEntry, boolean displayUnreadEntryNotifications, boolean displayCompletion, @Nullable ToastSettings newEntriesToast, Map<String, String> macros) {
        this.id = id;
        this.extend = extend;
        this.texture = texture;
        this.dynamicBookModel = dynamicBookModel;
        this.dynamicBookName = dynamicBookName;
        this.openSound = openSound != null ? openSound : Lavender.ITEM_BOOK_OPEN;
        this.flippingSound = flippingSound != null ? flippingSound : SoundEvents.BOOK_PAGE_TURN;
        this.introEntry = introEntry;
        this.displayUnreadEntryNotifications = displayUnreadEntryNotifications;
        this.displayCompletion = displayCompletion;
        this.newEntriesToast = newEntriesToast;
        macros.forEach((macro, replacement) -> {
            int argCount = (int)MACRO_ARG_PATTERN.matcher((CharSequence)replacement).results().count();
            if (argCount > 0) {
                if (!MACRO_NAME_PATTERN.asPredicate().test((String)macro)) {
                    throw new JsonParseException("Parametrized macro '" + macro + "' contains invalid characters. Parametrized macro names must only contain '[a-zA-Z0-9_-]'");
                }
                ArrayList<String> parts = new ArrayList<String>();
                IntArrayList argIndices = new IntArrayList();
                StringBuilder result = new StringBuilder((String)replacement);
                Matcher argMatcher = MACRO_ARG_PATTERN.matcher(result);
                while (argMatcher.find()) {
                    parts.add(result.substring(0, argMatcher.start()));
                    argIndices.add(Integer.parseInt(argMatcher.group().substring(1)) - 1);
                    result.delete(0, argMatcher.end());
                    argMatcher.reset();
                }
                parts.add(result.toString());
                this.macros.put(Pattern.compile(Pattern.quote(macro) + "\\(" + Stream.generate(() -> "(.*)").limit(argCount).collect(Collectors.joining(",")) + "\\)"), new Macro(parts, (IntList)argIndices));
            } else {
                this.zeroArgMacros.put((String)macro, (String)replacement);
            }
        });
    }

    public ResourceLocation id() {
        return this.id;
    }

    public boolean displayCompletion() {
        return this.displayCompletion;
    }

    public boolean displayUnreadEntryNotifications() {
        return this.displayUnreadEntryNotifications;
    }

    public Collection<Entry> entries() {
        return this.entriesView;
    }

    public Collection<Entry> orphanedEntries() {
        return this.orphanedEntriesView;
    }

    @Nullable
    public Entry introEntry() {
        return this.introEntry != null ? this.entryById(this.introEntry) : null;
    }

    @Nullable
    public Entry entryById(ResourceLocation entryId) {
        return this.entriesById.get(entryId);
    }

    @Nullable
    public Entry entryByAssociatedItem(ItemStack associatedStack) {
        Collection candidates = this.entriesByAssociatedItem.get((Object)associatedStack.getItem());
        for (Entry candidateEntry : candidates) {
            for (ItemStack candidateAssociatedStack : candidateEntry.associatedItems()) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)candidateAssociatedStack, (ItemStack)associatedStack)) continue;
                return candidateEntry;
            }
        }
        return null;
    }

    @Nullable
    public Collection<Entry> entriesByCategory(Category category) {
        List<Entry> entries = this.entriesByCategory.get(category);
        if (entries == null) {
            return null;
        }
        return Collections.unmodifiableCollection(entries);
    }

    @Nullable
    public Collection<Entry> descendantEntriesByCategory(Category category) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (Category candidate : this.categories.values()) {
            Collection<Entry> possibleEntries;
            if (candidate != category && !Objects.equals(candidate.parent(), category.id()) || (possibleEntries = this.entriesByCategory(candidate)) == null) continue;
            entries.addAll(possibleEntries);
        }
        if (entries.isEmpty()) {
            return null;
        }
        return entries;
    }

    public Collection<Category> categories() {
        return this.categoriesView;
    }

    @Nullable
    public Category categoryById(ResourceLocation categoryId) {
        return this.categories.get(categoryId);
    }

    public boolean shouldDisplayCategory(Category category, LocalPlayer player) {
        Collection<Entry> entries = this.descendantEntriesByCategory(category);
        if (entries == null) {
            return false;
        }
        boolean anyVisible = false;
        for (Entry entry : entries) {
            if (!entry.canPlayerView(player)) continue;
            anyVisible = true;
        }
        return anyVisible;
    }

    public boolean shouldDisplayUnreadNotification(Entry entry) {
        return this.displayUnreadEntryNotifications && !LavenderClientStorage.wasEntryViewed(this, entry);
    }

    public boolean shouldDisplayUnreadNotification(Category category, LocalPlayer player) {
        if (!this.displayUnreadEntryNotifications) {
            return false;
        }
        Collection<Entry> entries = this.descendantEntriesByCategory(category);
        if (entries == null) {
            return false;
        }
        for (Entry entry : entries) {
            if (!entry.canPlayerView(player) || LavenderClientStorage.wasEntryViewed(this, entry)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Entry landingPage() {
        return this.landingPage;
    }

    @Nullable
    public ResourceLocation texture() {
        return this.texture;
    }

    @Nullable
    public ResourceLocation dynamicBookModel() {
        return this.dynamicBookModel;
    }

    @Nullable
    public Component dynamicBookName() {
        return this.dynamicBookName;
    }

    public SoundEvent openSound() {
        return this.openSound;
    }

    public SoundEvent flippingSound() {
        return this.flippingSound;
    }

    @Nullable
    public ToastSettings newEntriesToast() {
        return this.newEntriesToast;
    }

    public int countVisibleEntries(LocalPlayer player) {
        int visible = 0;
        for (Entry entry : this.entriesById.values()) {
            if (!entry.canPlayerView(player)) continue;
            ++visible;
        }
        return visible;
    }

    String expandMacros(ResourceLocation entry, String input) {
        StringBuilder builder = new StringBuilder(input);
        int scans = 0;
        boolean anyExpansions = true;
        while (scans < 1000 && anyExpansions) {
            anyExpansions = false;
            for (String string : this.zeroArgMacros.keySet()) {
                int replaceIndex = builder.indexOf(string);
                while (replaceIndex != -1) {
                    String replacement = this.zeroArgMacros.get(string);
                    anyExpansions = true;
                    builder.replace(replaceIndex, replaceIndex + string.length(), replacement);
                    replaceIndex = builder.indexOf(string, replaceIndex + replacement.length());
                }
            }
            for (Pattern pattern : this.macros.keySet()) {
                Macro replacement = this.macros.get(pattern);
                Matcher matcher = pattern.matcher(builder);
                while (scans < 1000 && matcher.find()) {
                    ++scans;
                    anyExpansions = true;
                    ArrayList<String> args = new ArrayList<String>();
                    for (int i = 1; i <= matcher.groupCount(); ++i) {
                        args.add(matcher.group(i));
                    }
                    builder.replace(matcher.start(), matcher.end(), replacement.apply(args));
                    matcher.reset();
                }
            }
        }
        if (scans >= 1000) {
            Lavender.LOGGER.warn("Preprocessing of entry {} in book {} failed: Macro expansion proceeded for over 1000 scans, a circular macro invocation is likely", (Object)entry, (Object)this.id);
            return "{red}**Entry processing failed:**{}\n\n\nMacro expansion proceeded for over 1000 scans without reaching\na result - this is almost definitely due to a circular macro invocation\n";
        }
        return builder.toString();
    }

    void setLandingPage(@NotNull Entry landingPage) {
        this.landingPage = landingPage;
    }

    void addEntry(Entry entry) {
        if (this.resolvedExtend != null) {
            this.resolvedExtend.addEntry(entry);
        } else {
            this.entriesById.put(entry.id(), entry);
            entry.associatedItems().forEach(stack -> this.entriesByAssociatedItem.put((Object)stack.getItem(), (Object)entry));
            if (!entry.categories().isEmpty()) {
                for (ResourceLocation category : entry.categories()) {
                    if (this.categories.containsKey(category)) {
                        this.entriesByCategory.computeIfAbsent(this.categories.get(category), $ -> new ArrayList()).add(entry);
                        continue;
                    }
                    throw new RuntimeException("Could not load entry '" + String.valueOf(entry.id()) + "' because category '" + String.valueOf(category) + "' was not found in book '" + String.valueOf(this.effectiveId()) + "'");
                }
            } else {
                this.orphanedEntries.add(entry);
            }
        }
    }

    void addCategory(Category category) {
        if (this.resolvedExtend != null) {
            this.resolvedExtend.addCategory(category);
        } else {
            this.categories.put(category.id(), category);
        }
    }

    boolean tryResolveExtension() {
        if (this.extend == null) {
            return true;
        }
        this.resolvedExtend = BookLoader.get(this.extend);
        return this.resolvedExtend != null;
    }

    ResourceLocation effectiveId() {
        return this.resolvedExtend != null ? this.resolvedExtend.effectiveId() : this.id;
    }

    public record ToastSettings(ItemStack iconStack, Component bookName, @Nullable ResourceLocation backgroundSprite) {
    }

    public record Macro(List<String> parts, IntList argIndices) {
        String apply(List<String> args) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < this.argIndices.size(); ++i) {
                result.append(this.parts.get(i));
                int argIndex = this.argIndices.getInt(i);
                result.append(argIndex - 1 < args.size() ? args.get(i) : "");
            }
            result.append(this.parts.get(this.parts.size() - 1));
            return result.toString();
        }
    }

    public static interface BookmarkableElement {
        public String title();

        public Function<Sizing, io.wispforest.owo.ui.core.Component> iconFactory();
    }
}

